/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.inject.InjectionContext;
import com.atlassian.pageobjects.util.InjectingTestedProducts;
import com.atlassian.webdriver.testing.rule.ClassInjectionRule;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.Objects;
import org.junit.ClassRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class InstanceInjectionRules {
    private static final Logger logger = LoggerFactory.getLogger(InstanceInjectionRules.class);

    InstanceInjectionRules() {
    }

    static final class InstanceCollaboratingInjectionRule
    extends AbstractInstanceInjectionRule {
        InstanceCollaboratingInjectionRule(Object target) {
            super(target);
        }

        @Override
        protected boolean supportsInjection(Statement base, Description description) {
            return this.findClassInjectionRule(description).supportsInjection();
        }

        @Override
        protected InjectionContext injectionContext(Statement base, Description description) {
            return this.findClassInjectionRule(description).injectionContext();
        }

        private ClassInjectionRule<?> findClassInjectionRule(Description description) {
            List<ClassInjectionRule> rules = this.getClassInjectionRules(description);
            if (rules.isEmpty()) {
                throw new IllegalStateException("Test class configuration invalid: to use context-aware members injection rule you must declare a class rule as well. See JavaDoc of the com.atlassian.webdriver.testing.rule.InjectionRules class");
            }
            if (rules.size() > 1) {
                logger.warn("More than one field of type " + ClassInjectionRule.class.getName() + " annotated with @ClassRule. Using the first one to retrieve injection context");
            }
            return rules.get(0);
        }

        private List<ClassInjectionRule> getClassInjectionRules(Description description) {
            return new TestClass(description.getTestClass()).getAnnotatedFieldValues(null, ClassRule.class, ClassInjectionRule.class);
        }
    }

    static final class InstanceStandaloneInjectionRule<T extends TestedProduct<?>>
    extends AbstractInstanceInjectionRule {
        private final Supplier<T> product;

        InstanceStandaloneInjectionRule(Object target, Supplier<T> productSupplier) {
            super(target);
            this.product = Objects.requireNonNull(productSupplier, "productSupplier");
        }

        @Override
        protected boolean supportsInjection(Statement base, Description description) {
            return InjectingTestedProducts.supportsInjection((TestedProduct)((TestedProduct)this.product.get()));
        }

        @Override
        protected InjectionContext injectionContext(Statement base, Description description) {
            return InjectingTestedProducts.asInjectionContext((TestedProduct)((TestedProduct)this.product.get()));
        }
    }

    static abstract class AbstractInstanceInjectionRule
    implements TestRule {
        private final Object target;

        public AbstractInstanceInjectionRule(Object target) {
            this.target = Objects.requireNonNull(target, "target");
        }

        public final Statement apply(final Statement base, final Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    if (this.supportsInjection(base, description)) {
                        this.injectionContext(base, description).inject(target);
                    }
                    base.evaluate();
                }
            };
        }

        protected abstract boolean supportsInjection(Statement var1, Description var2);

        protected abstract InjectionContext injectionContext(Statement var1, Description var2);
    }
}

