/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing;

import com.atlassian.pageobjects.DefaultProductInstance;
import com.atlassian.pageobjects.MultiTenantTestedProduct;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.TestedProductFactory;
import com.atlassian.webdriver.pageobjects.WebDriverTester;
import java.net.URI;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.openqa.selenium.WebDriver;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class BaseTestProductTest {
    private static final String DEFAULT_HOST = "atlassian.com";
    private static final String DEFAULT_BASE_URL = "http://atlassian.com";
    private static final String HOMEPAGE_URL_TEMPLATE = "http://%s/%s";
    protected final ProductInstance productInstance = new DefaultProductInstance("http://atlassian.com", null, 80, "/");
    @Captor
    private ArgumentCaptor<String> urlCaptor;
    @Mock
    protected TestedProductFactory.TesterFactory<WebDriverTester> testerFactory;
    @Mock
    private WebDriverTester tester;
    @Mock
    protected WebDriver webDriver;

    @Before
    public void setup() {
        Mockito.when((Object)this.testerFactory.create()).thenReturn((Object)this.tester);
        Mockito.when((Object)this.tester.getDriver()).thenReturn((Object)this.webDriver);
    }

    protected abstract void goToHomePage();

    protected abstract String getHomePagePath();

    protected abstract MultiTenantTestedProduct getProduct();

    @Test
    public void testVisitsHomePageAtDefaultBaseUrl() {
        this.goToHomePage();
        ((WebDriverTester)Mockito.verify((Object)this.tester)).gotoUrl((String)this.urlCaptor.capture());
        Assert.assertThat((Object)this.urlCaptor.getValue(), (Matcher)Matchers.is((Object)this.homePageAtHost(DEFAULT_HOST)));
    }

    @Test
    public void testVisitsHomePageAtBaseUrlForHost() {
        String expectedHost = "mytenant";
        this.getProduct().setHost("mytenant");
        this.goToHomePage();
        ((WebDriverTester)Mockito.verify((Object)this.tester)).gotoUrl((String)this.urlCaptor.capture());
        Assert.assertThat((Object)this.urlCaptor.getValue(), (Matcher)Matchers.is((Object)this.homePageAtHost("mytenant")));
        String actualHost = URI.create((String)this.urlCaptor.getValue()).getHost();
        Assert.assertThat((Object)actualHost, (Matcher)Matchers.is((Object)"mytenant"));
    }

    private String homePageAtHost(String host) {
        return String.format(HOMEPAGE_URL_TEMPLATE, host, this.getHomePagePath());
    }
}

