/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.firefox;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.webdriver.WebDriverFactory;
import com.atlassian.webdriver.WebDriverProperties;
import com.atlassian.webdriver.browsers.AbstractBrowser;
import com.atlassian.webdriver.browsers.profile.ProfilePreferences;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.firefox.GeckoDriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FirefoxBrowser
extends AbstractBrowser<FirefoxDriver> {
    private static final Logger log = LoggerFactory.getLogger(FirefoxBrowser.class);
    public static final String FIREFOX_WEBDRIVER_DEVTOOLS_CONSOLE_STDOUT = "webdriver.firefox.devtools.console.stdout";
    public static final String FIREFOX_WEBDRIVER_DEVTOOLS_CONSOLE_REGEX = "webdriver.firefox.devtools.console.regex";
    public static final String FIREFOX_WEBDRIVER_LOGFILE = "webdriver.firefox.logfile";
    public static final String FIREFOX_DEVTOOLS_CONSOLE_STDOUT_CONTENT = "devtools.console.stdout.content";

    public static FirefoxDriver getDriver(BrowserConfig browserConfig, String browserPath, @Nullable Capabilities capabilities) {
        return (FirefoxDriver)FirefoxBrowser.getDriver(FirefoxBrowser.class, browserConfig, browserPath, capabilities);
    }

    @Override
    public FirefoxDriver getDriver(@Nullable Capabilities capabilities) {
        GeckoDriverService.Builder firefoxBuilder = new GeckoDriverService.Builder();
        FirefoxBrowser.setSystemProperties(firefoxBuilder);
        return FirefoxBrowser.constructFirefoxDriver(firefoxBuilder, null, capabilities);
    }

    @Override
    public FirefoxDriver getDriver(BrowserConfig browserConfig, @Nullable Capabilities capabilities) {
        GeckoDriverService.Builder firefoxBuilder = new GeckoDriverService.Builder();
        if (browserConfig != null && browserConfig.getBinaryPath() != null) {
            firefoxBuilder.usingFirefoxBinary(new FirefoxBinary(new File(browserConfig.getBinaryPath())));
            FirefoxProfile profile = null;
            if (browserConfig.getProfilePath() != null) {
                File profilePath = new File(browserConfig.getProfilePath());
                profile = new FirefoxProfile();
                FirefoxBrowser.addExtensionsToProfile(profile, profilePath);
                FirefoxBrowser.addPreferencesToProfile(profile, profilePath);
                FirefoxBrowser.addGeckoDriver(firefoxBuilder, profilePath);
            }
            FirefoxBrowser.setSystemProperties(firefoxBuilder);
            return FirefoxBrowser.constructFirefoxDriver(firefoxBuilder, profile, capabilities);
        }
        return this.getDriver(capabilities);
    }

    private static void addCommandLine(FirefoxOptions options) {
        String[] switches = StringUtils.split((String)WebDriverProperties.WEBDRIVER_FIREFOX_SWITCHES.getSystemProperty(), (String)",");
        if (switches != null && switches.length > 0) {
            List<String> switchList = Arrays.asList(switches);
            log.info("Setting command line arguments for Firefox: " + switchList);
            options.addArguments(switchList);
        }
    }

    private static void addGeckoDriver(GeckoDriverService.Builder firefoxBuilder, File profilePath) {
        File geckoDriverFile;
        if (profilePath != null && (geckoDriverFile = new File(profilePath, "geckodriver" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : ""))).exists()) {
            firefoxBuilder.usingDriverExecutable(new File(geckoDriverFile.toString()));
        }
    }

    private static void addPreferencesToProfile(FirefoxProfile profile, File profilePath) {
        File profilePreferencesFile = new File(profilePath, "profile.preferences");
        if (profilePreferencesFile.exists()) {
            ProfilePreferences profilePreferences = new ProfilePreferences(profilePreferencesFile);
            profilePreferences.getPreferences().forEach((key, value) -> {
                if (value instanceof Integer) {
                    profile.setPreference(key, ((Integer)value).intValue());
                } else if (value instanceof Boolean) {
                    profile.setPreference(key, ((Boolean)value).booleanValue());
                } else {
                    profile.setPreference(key, (String)value);
                }
            });
        }
    }

    private static void addExtensionsToProfile(FirefoxProfile profile, File profilePath) {
        File[] xpiFiles = profilePath.listFiles(file -> file.getName().matches(".*\\.xpi$"));
        if (xpiFiles != null) {
            for (File extension : xpiFiles) {
                profile.addExtension(extension);
            }
        }
    }

    @Override
    public FirefoxDriver getDriver(String browserPath, @Nullable Capabilities capabilities) {
        if (browserPath != null) {
            GeckoDriverService.Builder firefoxBuilder = new GeckoDriverService.Builder();
            firefoxBuilder.usingFirefoxBinary(new FirefoxBinary(new File(browserPath)));
            FirefoxBrowser.setSystemProperties(firefoxBuilder);
            return FirefoxBrowser.constructFirefoxDriver(firefoxBuilder, null, capabilities);
        }
        log.info("Browser path was null, falling back to default firefox driver.");
        return this.getDriver(capabilities);
    }

    public static void updateOptions(FirefoxOptions options) {
        options.setHeadless(WebDriverFactory.isBrowserHeadless());
        options.addPreference(FIREFOX_DEVTOOLS_CONSOLE_STDOUT_CONTENT, Boolean.getBoolean(FIREFOX_WEBDRIVER_DEVTOOLS_CONSOLE_STDOUT));
    }

    private static FirefoxDriver constructFirefoxDriver(GeckoDriverService.Builder firefoxBuilder, FirefoxProfile profile, @Nullable Capabilities capabilities) {
        if (profile == null) {
            profile = new FirefoxProfile();
        }
        FirefoxOptions options = capabilities != null ? new FirefoxOptions(capabilities) : new FirefoxOptions();
        options.setProfile(profile);
        FirefoxBrowser.addCommandLine(options);
        FirefoxBrowser.updateOptions(options);
        FirefoxBrowser.showEnv();
        return new FirefoxDriver((GeckoDriverService)firefoxBuilder.build(), options);
    }

    private static void showEnv() {
        System.out.println("==== System properties ====");
        System.out.println(System.getProperties());
    }

    private static void setSystemProperties(GeckoDriverService.Builder builder) {
        System.out.println("==== Setting system properties ====");
        System.out.println("Display: " + System.getProperty("DISPLAY"));
        if (System.getProperty("DISPLAY") != null) {
            builder.withEnvironment((Map)ImmutableMap.of((Object)"DISPLAY", (Object)System.getProperty("DISPLAY")));
        }
        WebDriverProperties.WEBDRIVER_HTTP_FACTORY.setSystemProperty("apache");
        System.setProperty("webdriver.http.factory", "apache");
        FirefoxBrowser.setFirefoxWebdriverLogfile();
    }

    public static void setFirefoxWebdriverLogfile() {
        try {
            String logFilePath;
            String systemPropertyFilePath = System.getProperty(FIREFOX_WEBDRIVER_LOGFILE, "");
            if (!systemPropertyFilePath.isEmpty()) {
                File systemPropertyFile = new File(systemPropertyFilePath);
                if (!systemPropertyFile.exists()) {
                    systemPropertyFile.createNewFile();
                }
                logFilePath = systemPropertyFile.getAbsolutePath();
            } else {
                logFilePath = File.createTempFile("firefox-test-log", ".tmp").getAbsolutePath();
            }
            System.setProperty(FIREFOX_WEBDRIVER_LOGFILE, logFilePath);
        }
        catch (IOException e) {
            log.warn("Unable to create file for 'webdriver.firefox.logfile'. JS console error reporting will be unavailable.", (Throwable)e);
        }
    }
}

