/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.webdriver.BrowserstackWebDriverFactory;
import com.atlassian.webdriver.RemoteWebDriverFactory;
import com.atlassian.webdriver.WebDriverContext;
import com.atlassian.webdriver.WebDriverFactory;
import com.atlassian.webdriver.browsers.AutoInstallConfiguration;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.browserstack.local.Local;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleAwareWebDriverGrid {
    private static final Logger log = LoggerFactory.getLogger(LifecycleAwareWebDriverGrid.class);
    private static final Map<String, WebDriverContext> drivers = new ConcurrentHashMap<String, WebDriverContext>();
    private static final Map<String, WeakReference<Thread>> SHUTDOWN_HOOKS = new ConcurrentHashMap<String, WeakReference<Thread>>();

    private LifecycleAwareWebDriverGrid() {
    }

    public static WebDriverContext getDriverContext() {
        WebDriverContext context;
        String browserProperty = WebDriverFactory.getBrowserProperty();
        WebDriverContext configuredContext = drivers.get(browserProperty);
        if (configuredContext != null) {
            return configuredContext;
        }
        if (BrowserstackWebDriverFactory.matches(browserProperty)) {
            log.info("Loading browserstack driver");
            Local bsLocal = new Local();
            try {
                context = new BrowserstackWebDriverFactory().getDriverContext(bsLocal);
                Thread quitter = new Thread(() -> {
                    try {
                        if (bsLocal.isRunning()) {
                            bsLocal.stop();
                        }
                    }
                    catch (Exception e) {
                        LifecycleAwareWebDriverGrid.onQuitError(context.getDriver(), e);
                    }
                });
                SHUTDOWN_HOOKS.put(browserProperty, new WeakReference<Thread>(quitter));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not start Browserstack driver", e);
            }
        } else if (RemoteWebDriverFactory.matches(browserProperty)) {
            log.info("Loading remote driver: " + browserProperty);
            context = RemoteWebDriverFactory.getDriverContext(browserProperty);
        } else {
            log.info("Loading local driver: " + browserProperty);
            BrowserConfig browserConfig = AutoInstallConfiguration.setupBrowser();
            context = WebDriverFactory.getDriverContext(browserConfig);
        }
        drivers.put(browserProperty, context);
        LifecycleAwareWebDriverGrid.addShutdownHook(browserProperty, context.getDriver());
        return context;
    }

    public static void shutdown() {
        for (Map.Entry<String, WebDriverContext> driver : drivers.entrySet()) {
            LifecycleAwareWebDriverGrid.quit(driver.getValue().getDriver());
            LifecycleAwareWebDriverGrid.removeHook(driver);
        }
        drivers.clear();
        SHUTDOWN_HOOKS.clear();
    }

    private static void removeHook(Map.Entry<String, WebDriverContext> driver) {
        Thread hook;
        WeakReference<Thread> hookRef = SHUTDOWN_HOOKS.get(driver.getKey());
        Thread thread = hook = hookRef != null ? (Thread)hookRef.get() : null;
        if (hook != null) {
            Runtime.getRuntime().removeShutdownHook(hook);
        }
    }

    private static void quit(WebDriver webDriver) {
        try {
            webDriver.quit();
        }
        catch (WebDriverException e) {
            LifecycleAwareWebDriverGrid.onQuitError(webDriver, (Exception)((Object)e));
        }
    }

    private static void addShutdownHook(final String browserProperty, final WebDriver driver) {
        Thread quitter = new Thread(){

            @Override
            public void run() {
                log.debug("Running shut down hook for {}", (Object)driver);
                try {
                    drivers.remove(browserProperty);
                    log.info("Quitting {}", (Object)WebDriverUtil.getUnderlyingDriver(driver));
                    driver.quit();
                    log.debug("Finished shutdown hook {}", (Object)this);
                }
                catch (NullPointerException e) {
                    LifecycleAwareWebDriverGrid.onQuitError(driver, e);
                }
                catch (WebDriverException e) {
                    LifecycleAwareWebDriverGrid.onQuitError(driver, (Exception)((Object)e));
                }
            }
        };
        SHUTDOWN_HOOKS.put(browserProperty, new WeakReference<1>(quitter));
        Runtime.getRuntime().addShutdownHook(quitter);
    }

    private static void onQuitError(WebDriver webDriver, Exception e) {
        log.warn("Exception when trying to quit driver {}: {}", (Object)webDriver, (Object)e.getMessage());
        log.debug("Exception when trying to quit driver - details", (Throwable)e);
    }
}

