/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.webdriver.WebDriverProperties;
import com.atlassian.webdriver.utils.WebDriverUtil;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.logging.LoggingPreferences;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesiredCapabilitiesFactory {
    private static final Logger log = LoggerFactory.getLogger(DesiredCapabilitiesFactory.class);

    @Nonnull
    public static DesiredCapabilities defaultCapabilitiesForBrowser(Browser browserType) throws UnsupportedOperationException {
        DesiredCapabilities capabilities;
        switch (browserType) {
            case FIREFOX: {
                capabilities = DesiredCapabilities.firefox();
                break;
            }
            case CHROME: {
                capabilities = DesiredCapabilities.chrome();
                break;
            }
            case EDGE: {
                capabilities = DesiredCapabilities.edge();
                break;
            }
            case IE: {
                capabilities = DesiredCapabilities.internetExplorer();
                break;
            }
            case IPHONE: {
                capabilities = DesiredCapabilities.iphone();
                break;
            }
            case IPAD: {
                capabilities = DesiredCapabilities.ipad();
                break;
            }
            case ANDROID: {
                capabilities = DesiredCapabilities.android();
                break;
            }
            case SAFARI: {
                throw new UnsupportedOperationException("Safari is not a supported Browser Type");
            }
            case OPERA: {
                throw new UnsupportedOperationException("Opera is not a supported Browser Type");
            }
            default: {
                log.error("Unknown browser: {}, defaulting to firefox.", (Object)browserType);
                capabilities = DesiredCapabilities.firefox();
            }
        }
        return capabilities;
    }

    @Nonnull
    public static DesiredCapabilities customCapabilitiesFromSystemProperty() {
        String capabilitiesStr = WebDriverProperties.WEBDRIVER_CAPABILITIES.getSystemProperty();
        log.info("Loading custom capabilities " + capabilitiesStr);
        return WebDriverUtil.createCapabilitiesFromString(capabilitiesStr);
    }

    @Nonnull
    public static DesiredCapabilities customCapabilitiesForLogging() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        LoggingPreferences loggingPreferences = DesiredCapabilitiesFactory.loggingPreferencesFromProperties();
        DesiredCapabilitiesFactory.setCapabilityIfNotNull(capabilities, "loggingPrefs", loggingPreferences);
        return capabilities;
    }

    @Nullable
    private static LoggingPreferences loggingPreferencesFromProperties() {
        LoggingPreferences loggingPreferences = new LoggingPreferences();
        DesiredCapabilitiesFactory.enableLogTypeIfNonNull(loggingPreferences, "browser", WebDriverProperties.WEBDRIVER_LOGGING_BROWSER.getSystemProperty());
        DesiredCapabilitiesFactory.enableLogTypeIfNonNull(loggingPreferences, "client", WebDriverProperties.WEBDRIVER_LOGGING_CLIENT.getSystemProperty());
        DesiredCapabilitiesFactory.enableLogTypeIfNonNull(loggingPreferences, "driver", WebDriverProperties.WEBDRIVER_LOGGING_DRIVER.getSystemProperty());
        return loggingPreferences.getEnabledLogTypes().isEmpty() ? null : loggingPreferences;
    }

    private static void setCapabilityIfNotNull(DesiredCapabilities capabilities, String capabilityName, @Nullable Object value) {
        if (value != null) {
            capabilities.setCapability(capabilityName, value);
        }
    }

    private static void enableLogTypeIfNonNull(LoggingPreferences loggingPreferences, String logType, @Nullable String logLevel) {
        try {
            if (logLevel != null) {
                loggingPreferences.enable(logType, Level.parse(logLevel));
            }
        }
        catch (IllegalArgumentException ex) {
            log.warn("Invalid log level: {} for log type: {}", (Object)logLevel, (Object)logType);
        }
    }
}

