(function(window) {

    function extend(destination, source) {
        for (var property in source) {
            destination[property] = source[property];
        }
        return destination;
    }

    ATLWD.events = {

        fireEventForElement: function(element, eventName, eventOptions) {
            window.console.log("fireEventForElement");
            var options = extend(this.defaultOptions, eventOptions || {});
            var oEvent, eventType = null;

            for (var name in this.eventMatchers) {
                if (this.eventMatchers[name].test(eventName)) {
                    eventType = name;
                    break;
                }
            }

            if (!eventType) {
                throw new SyntaxError('Only HTMLEvents and MouseEvents interfaces are supported');
            }

            if (document.createEvent) {
                oEvent = document.createEvent(eventType);
                if (eventType == 'HTMLEvents') {
                    oEvent.initEvent(eventName, options.bubbles, options.cancelable);
                } else {
                    oEvent.initMouseEvent(eventName, options.bubbles, options.cancelable, document.defaultView,
                            options.button, options.pointerX, options.pointerY, options.pointerX, options.pointerY,
                            options.ctrlKey, options.altKey, options.shiftKey, options.metaKey, options.button, element);
                }
                element.dispatchEvent(oEvent);
            } else {
                options.clientX = options.pointerX;
                options.clientY = options.pointerY;
                var evt = document.createEventObject();
                oEvent = extend(evt, options);
                element.fireEvent('on' + eventName, oEvent);
            }
            return element;
        },

        eventMatchers: {
            'HTMLEvents': /^(?:load|unload|abort|error|select|change|submit|reset|focus|blur|resize|scroll)$/,
            'MouseEvents': /^(?:click|dblclick|mouse(?:down|up|over|move|out))$/
        },

        defaultOptions: {
            pointerX: 0,
            pointerY: 0,
            button: 0,
            ctrlKey: false,
            altKey: false,
            shiftKey: false,
            metaKey: false,
            bubbles: true,
            cancelable: true
        }
    };
})(window);



