/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver.retriever;

import com.atlassian.webdriver.waiter.webdriver.retriever.Supplier;
import com.google.common.base.Preconditions;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebElement;

public class WebElementRetriever {
    private final Supplier<WebElement> elementSupplier;

    private WebElementRetriever(Supplier<WebElement> elementSupplier) {
        this.elementSupplier = (Supplier)Preconditions.checkNotNull(elementSupplier, (Object)"The element supplier can not be null.");
    }

    public static WebElementRetriever newLocatorRetriever(final By locator, final SearchContext context) {
        Preconditions.checkNotNull((Object)locator, (Object)"The locator can not be null.");
        Preconditions.checkNotNull((Object)context, (Object)"The search context can not be null.");
        return new WebElementRetriever(new Supplier<WebElement>(){

            @Override
            public WebElement supply() {
                return context.findElement(locator);
            }
        });
    }

    public static WebElementRetriever newWebElementRetriever(final WebElement webElement) {
        Preconditions.checkNotNull((Object)webElement, (Object)"The webelement can not be null.");
        return new WebElementRetriever(new Supplier<WebElement>(){

            @Override
            public WebElement supply() {
                return webElement;
            }
        });
    }

    public WebElement retrieveElement() {
        return this.elementSupplier.supply();
    }
}

