/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webdriver.waiter.ElementQuery;
import com.atlassian.webdriver.waiter.ExecutableWaiterQuery;
import com.atlassian.webdriver.waiter.FunctionQuery;
import com.atlassian.webdriver.waiter.Query;
import com.atlassian.webdriver.waiter.WaiterQuery;
import com.atlassian.webdriver.waiter.webdriver.AtlassianWebDriverWait;
import com.atlassian.webdriver.waiter.webdriver.WebDriverElementQuery;
import com.atlassian.webdriver.waiter.webdriver.WebDriverFunctionQuery;
import com.atlassian.webdriver.waiter.webdriver.WebDriverQueryBuilder;
import com.atlassian.webdriver.waiter.webdriver.function.ConditionFunction;
import com.atlassian.webdriver.waiter.webdriver.retriever.WebElementRetriever;
import com.google.common.base.Function;
import org.apache.commons.lang.NotImplementedException;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

@ExperimentalApi
class WebDriverWaiterQuery
implements WaiterQuery {
    private final WebDriverQueryBuilder queryBuilder;

    public WebDriverWaiterQuery(WebDriverQueryBuilder builder) {
        this.queryBuilder = builder;
    }

    @Override
    public FunctionQuery function(ConditionFunction func) {
        return new WebDriverFunctionQuery(this.queryBuilder, func);
    }

    @Override
    public ElementQuery element(By locator) {
        return this.element(locator, (SearchContext)this.queryBuilder.getDriver());
    }

    @Override
    public ElementQuery element(By locator, SearchContext context) {
        return new WebDriverElementQuery(this.queryBuilder, WebElementRetriever.newLocatorRetriever(locator, context));
    }

    @Override
    public ElementQuery element(WebElement element) {
        return new WebDriverElementQuery(this.queryBuilder, WebElementRetriever.newWebElementRetriever(element));
    }

    static class OrQuery
    implements Query {
        OrQuery() {
        }

        @Override
        public ConditionFunction build() {
            throw new NotImplementedException("This should not be called.");
        }
    }

    static class AndQuery
    implements Query {
        AndQuery() {
        }

        @Override
        public ConditionFunction build() {
            throw new NotImplementedException("This should not be called.");
        }
    }

    static class WebDriverExecutableWaiterQuery
    implements ExecutableWaiterQuery {
        private final WebDriverQueryBuilder queryBuilder;

        public WebDriverExecutableWaiterQuery(WebDriverQueryBuilder queryBuilder) {
            this.queryBuilder = queryBuilder;
        }

        @Override
        public void execute() {
            Function<WebDriver, Boolean> func = this.queryBuilder.build();
            new AtlassianWebDriverWait(this.queryBuilder.getDriver(), this.queryBuilder.getTimeout()).until(func);
        }

        @Override
        public WaiterQuery and() {
            this.queryBuilder.add(new AndQuery());
            return new WebDriverWaiterQuery(this.queryBuilder);
        }

        @Override
        public WaiterQuery or() {
            this.queryBuilder.add(new OrQuery());
            return new WebDriverWaiterQuery(this.queryBuilder);
        }
    }
}

