/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.waiter.webdriver;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.waiter.Waiter;
import com.atlassian.webdriver.waiter.WaiterQuery;
import com.atlassian.webdriver.waiter.webdriver.WebDriverQueryBuilder;
import com.atlassian.webdriver.waiter.webdriver.WebDriverWaiterQuery;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

@ExperimentalApi
public class WebDriverWaiter
implements Waiter {
    private static final long DEFAULT_INTERVAL_TIME = 30L;
    private static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.SECONDS;
    private AtlassianWebDriver driver;

    @Inject
    public WebDriverWaiter(AtlassianWebDriver driver) {
        this.driver = driver;
    }

    @Override
    public WaiterQuery until() {
        return this.until(30L, DEFAULT_TIME_UNIT);
    }

    @Override
    public WaiterQuery until(long timeout) {
        return this.until(timeout, TimeUnit.SECONDS);
    }

    @Override
    public WaiterQuery until(long time, TimeUnit unit) {
        long millisTimeout;
        switch (unit) {
            case SECONDS: {
                millisTimeout = time * 1000L;
                break;
            }
            case MILLISECONDS: {
                millisTimeout = time;
                break;
            }
            case MINUTES: {
                millisTimeout = 60000L * time;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The provided TimeUnit: " + (Object)((Object)unit) + " is not supported");
            }
        }
        return new WebDriverWaiterQuery(new WebDriverQueryBuilder(this.driver, millisTimeout));
    }
}

