/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.element;

import com.atlassian.webdriver.utils.Check;
import org.apache.commons.lang.Validate;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

abstract class ElementLocationCondition
implements ExpectedCondition<Boolean> {
    private final By by;
    private final SearchContext at;
    private final Locatable locatable;

    ElementLocationCondition(By by, Locatable locatable) {
        this(by, null, locatable);
    }

    ElementLocationCondition(By by, SearchContext at, Locatable locatable) {
        Validate.notNull((Object)by, (String)"by cannot be null.");
        this.by = by;
        this.at = at;
        this.locatable = locatable;
    }

    public Boolean apply(WebDriver webDriver) {
        if (this.locatable.equals((Object)Locatable.LOCATED)) {
            return Check.elementExists(this.by, (SearchContext)(this.at == null ? webDriver : this.at));
        }
        return !Check.elementExists(this.by, (SearchContext)(this.at == null ? webDriver : this.at));
    }

    static enum Locatable {
        LOCATED,
        NOTLOCATED;

    }
}

