/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import com.atlassian.webdriver.utils.WebElementUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JavaScriptUtils {
    private JavaScriptUtils() {
    }

    @Deprecated
    public static String innerHtml(WebElement element, WebDriver driver) {
        return WebElementUtil.getInnerHtml(element, driver);
    }

    public static void dispatchEvent(String eventType, WebElement element, WebDriver webDriver) {
        JavaScriptUtils.loadScript("js/atlassian/events/customevents.js", webDriver);
        JavaScriptUtils.execute("ATLWD.events.fireEventForElement(arguments[0],'" + eventType + "');", webDriver, element);
    }

    public static void dispatchMouseEvent(String event, WebElement el, WebDriver driver) {
        JavaScriptUtils.dispatchEvent(event, el, driver);
    }

    public static boolean loadScript(String jsScriptName, WebDriver driver) {
        if (!JavaScriptUtils.isScriptLoaded(jsScriptName, driver)) {
            JavaScriptUtils.doLoadScript(jsScriptName, driver, true);
            return true;
        }
        return false;
    }

    public static boolean isScriptLoaded(String jsScriptName, WebDriver webDriver) {
        JavaScriptUtils.loadCoreScript(webDriver);
        return JavaScriptUtils.execute(Boolean.class, "return window.ATLWD.scriptloader.isLoaded('" + jsScriptName + "');", webDriver, new Object[0]);
    }

    private static void doLoadScript(String jsScriptName, WebDriver driver, boolean addToLoaded) {
        InputStream scriptStream = null;
        try {
            scriptStream = JavaScriptUtils.loadResource(jsScriptName);
            String jsSource = IOUtils.toString((InputStream)scriptStream);
            if (addToLoaded) {
                jsSource = "window.ATLWD.scriptloader.scriptLoaded('" + jsScriptName + "');" + jsSource;
            }
            JavaScriptUtils.execute(jsSource, driver, new Object[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load the javascript file: " + jsScriptName, e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)scriptStream);
        }
    }

    private static void loadCoreScript(WebDriver webDriver) {
        if (Boolean.FALSE.equals(JavaScriptUtils.isCoreLoaded(webDriver))) {
            JavaScriptUtils.doLoadScript("js/atlassian/atlassian-webdriver-core.js", webDriver, false);
            JavaScriptUtils.doLoadScript("js/atlassian/scriptloader/scriptloader.js", webDriver, false);
            JavaScriptUtils.loadScript("js/jquery/jquery-1.4.2.min.js", webDriver);
            JavaScriptUtils.execute("ATLWD.loadJquery()", webDriver, new Object[0]);
        }
    }

    private static boolean isCoreLoaded(WebDriver webDriver) {
        return JavaScriptUtils.execute(Boolean.class, "return window.ATLWD != undefined && window.ATLWD.scriptloader != undefined", webDriver, new Object[0]);
    }

    private static InputStream loadResource(String jsScriptName) {
        InputStream is = ClassLoader.getSystemClassLoader().getResourceAsStream(jsScriptName);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(jsScriptName);
        }
        if (is == null) {
            throw new RuntimeException("javascript resource " + jsScriptName + " not found by system or context classloaders.");
        }
        return is;
    }

    public static <T> T execute(String js, WebDriver driver, Object ... arguments) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        return (T)jsExecutor.executeScript(js, arguments);
    }

    public static <T> T execute(Class<T> expectedReturn, String js, WebDriver driver, Object ... arguments) {
        JavascriptExecutor jsExecutor = (JavascriptExecutor)driver;
        Object result = jsExecutor.executeScript(js, arguments);
        if (result != null && !expectedReturn.isInstance(result)) {
            throw new ClassCastException("Expected result type " + expectedReturn.getName() + " but was: " + result.getClass().getName());
        }
        return expectedReturn.cast(result);
    }
}

