/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.browsers.WebDriverBrowserAutoInstall;
import com.atlassian.webdriver.testing.rule.FailsafeExternalResource;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import org.openqa.selenium.WebDriver;

public class SessionCleanupRule
extends FailsafeExternalResource {
    private final Supplier<? extends WebDriver> webDriver;

    public SessionCleanupRule(Supplier<? extends WebDriver> webDriver) {
        this.webDriver = webDriver;
    }

    @Inject
    public SessionCleanupRule(WebDriver webDriver) {
        this((Supplier<? extends WebDriver>)Suppliers.ofInstance((Object)webDriver));
    }

    public SessionCleanupRule() {
        this(WebDriverBrowserAutoInstall.driverSupplier());
    }

    protected void before() throws Throwable {
        this.cleanUp();
    }

    protected void after() {
        this.cleanUp();
    }

    private void cleanUp() {
        WebDriver driver = (WebDriver)this.webDriver.get();
        if (driver != null) {
            driver.manage().deleteAllCookies();
        }
    }
}

