/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.chrome;

import com.atlassian.browsers.BrowserConfig;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeDriverService;
import org.openqa.selenium.chrome.ChromeOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeBrowser {
    private static final Logger log = LoggerFactory.getLogger(ChromeBrowser.class);

    private ChromeBrowser() {
    }

    public static ChromeDriver getChromeDriver() {
        return new ChromeDriver();
    }

    public static ChromeDriver getChromeDriver(BrowserConfig browserConfig) {
        if (browserConfig != null) {
            ChromeOptions options = new ChromeOptions();
            options.setBinary(browserConfig.getBinaryPath());
            ChromeBrowser.setDefaultArgs(options);
            ChromeBrowser.addCommandLine(options);
            ChromeDriverService.Builder chromeServiceBuilder = new ChromeDriverService.Builder();
            ChromeBrowser.setChromeServicePath(browserConfig, chromeServiceBuilder);
            ChromeBrowser.setEnvironment(chromeServiceBuilder);
            chromeServiceBuilder.usingAnyFreePort();
            ChromeDriverService chromeDriverService = (ChromeDriverService)chromeServiceBuilder.build();
            return new ChromeDriver(chromeDriverService, options);
        }
        return ChromeBrowser.getChromeDriver();
    }

    public static ChromeDriver getChromeDriver(String browserPath) {
        if (browserPath != null) {
            ChromeOptions options = new ChromeOptions();
            options.setBinary(browserPath);
            return new ChromeDriver(options);
        }
        log.info("Browser path was null, falling back to default chrome driver.");
        return ChromeBrowser.getChromeDriver();
    }

    private static void setDefaultArgs(ChromeOptions options) {
        options.addArguments(new String[]{"--disable-setuid-sandbox"});
    }

    private static void setChromeServicePath(BrowserConfig browserConfig, ChromeDriverService.Builder chromeServiceBuilder) {
        File profilePath;
        File chromeDriverFile;
        if (browserConfig.getProfilePath() != null && (chromeDriverFile = new File(profilePath = new File(browserConfig.getProfilePath()), "chromedriver")).exists()) {
            chromeServiceBuilder.usingDriverExecutable(chromeDriverFile);
        }
    }

    private static void addCommandLine(ChromeOptions options) {
        String[] switches = StringUtils.split((String)System.getProperty("webdriver.chrome.switches"), (String)",");
        if (switches != null && switches.length > 0) {
            List<String> switchList = Arrays.asList(switches);
            log.info("Setting command line arguments for Chrome: " + switchList);
            options.addArguments(switchList);
        }
    }

    private static void setEnvironment(ChromeDriverService.Builder chromeDriverServiceBuilder) {
        HashMap env = Maps.newHashMap();
        if (System.getProperty("DISPLAY") != null) {
            env.put("DISPLAY", System.getProperty("DISPLAY"));
        }
        chromeDriverServiceBuilder.withEnvironment((Map)env);
    }
}

