/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers;

import com.atlassian.browsers.AbstractInstallConfigurator;
import com.atlassian.browsers.BrowserAutoInstaller;
import com.atlassian.browsers.BrowserConfig;
import com.atlassian.browsers.BrowserConfiguration;
import com.atlassian.browsers.InstallConfigurator;
import com.atlassian.webdriver.browsers.WebDriverBrowserConfiguration;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;

public class AutoInstallConfiguration {
    public static BrowserConfig setupBrowser() {
        return AutoInstallConfiguration.setupBrowser(new WebDriverBrowserConfiguration());
    }

    public static BrowserConfig setupBrowser(BrowserConfiguration browserConfiguration) {
        final AtomicReference ref = new AtomicReference();
        BrowserAutoInstaller browserAutoInstaller = new BrowserAutoInstaller(browserConfiguration, (InstallConfigurator)new AbstractInstallConfigurator(){

            public void setupBrowser(@Nonnull BrowserConfig browserConfig) {
                ref.set(browserConfig);
                switch (browserConfig.getBrowserType()) {
                    case FIREFOX: {
                        System.setProperty("webdriver.firefox.bin", browserConfig.getBinaryPath());
                        break;
                    }
                    case CHROME: {
                        System.setProperty("webdriver.chrome.bin", browserConfig.getBinaryPath());
                    }
                }
            }
        });
        browserAutoInstaller.setupBrowser();
        return (BrowserConfig)ref.get();
    }
}

