/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.fugue.retry.ExceptionHandler;
import com.atlassian.fugue.retry.RetryFactory;
import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.pageobjects.util.BrowserUtil;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.DefaultAtlassianWebDriver;
import com.atlassian.webdriver.RemoteWebDriverFactory;
import com.atlassian.webdriver.browsers.chrome.ChromeBrowser;
import com.atlassian.webdriver.browsers.firefox.FirefoxBrowser;
import com.atlassian.webdriver.browsers.ie.IeBrowser;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.WebClient;
import com.google.common.base.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    private static final Pattern browserPathPattern = Pattern.compile("^([A-Za-z0-9_.-]+):path=(.*)$");
    private static final int GET_DRIVER_RETRY_COUNT = Integer.getInteger("webdriver.init.retry", 1);

    private WebDriverFactory() {
    }

    public static AtlassianWebDriver getDriver() {
        return WebDriverFactory.getDriver(null);
    }

    public static String getBrowserProperty() {
        return System.getProperty("webdriver.browser", "firefox");
    }

    public static Browser getBrowser() {
        String browserProperty = WebDriverFactory.getBrowserProperty();
        return WebDriverFactory.getBrowser(browserProperty);
    }

    public static Browser getBrowser(String browserProperty) {
        if (RemoteWebDriverFactory.matches(browserProperty)) {
            return RemoteWebDriverFactory.getBrowser(browserProperty);
        }
        Matcher matcher = browserPathPattern.matcher(browserProperty);
        if (matcher.matches()) {
            browserProperty = matcher.group(1);
        }
        return Browser.typeOf((String)browserProperty);
    }

    public static AtlassianWebDriver getDriver(final BrowserConfig browserConfig) {
        Supplier<AtlassianWebDriver> runnable = new Supplier<AtlassianWebDriver>(){

            public AtlassianWebDriver get() {
                return WebDriverFactory.getDriverNoRetry(browserConfig);
            }
        };
        ExceptionHandler exceptionLogger = new ExceptionHandler(){

            public void handle(RuntimeException ex) {
                log.warn("Error creating WebDriver object, retrying.. ({})", (Object)ex.toString());
                log.debug("Error creating WebDriver object - stack trace", (Throwable)ex);
            }
        };
        return (AtlassianWebDriver)RetryFactory.create((Supplier)runnable, (int)GET_DRIVER_RETRY_COUNT, (ExceptionHandler)exceptionLogger).get();
    }

    private static AtlassianWebDriver getDriverNoRetry(BrowserConfig browserConfig) {
        HtmlUnitDriver driver;
        String browserPath = null;
        String BROWSER = WebDriverFactory.getBrowserProperty();
        if (RemoteWebDriverFactory.matches(BROWSER)) {
            log.info("Loading RemoteWebDriverFactory driver " + BROWSER);
            return RemoteWebDriverFactory.getDriver(BROWSER);
        }
        Matcher matcher = browserPathPattern.matcher(BROWSER);
        if (matcher.matches()) {
            BROWSER = matcher.group(1);
            browserPath = matcher.group(2);
        }
        Browser browserType = Browser.typeOf((String)BROWSER);
        switch (browserType) {
            case FIREFOX: {
                if (browserPath == null && browserConfig != null) {
                    driver = FirefoxBrowser.getFirefoxDriver(browserConfig);
                    break;
                }
                if (browserPath != null) {
                    driver = FirefoxBrowser.getFirefoxDriver(browserPath);
                    break;
                }
                driver = FirefoxBrowser.getFirefoxDriver();
                break;
            }
            case CHROME: {
                if (browserPath == null && browserConfig != null) {
                    driver = ChromeBrowser.getChromeDriver(browserConfig);
                    break;
                }
                if (browserPath != null) {
                    driver = ChromeBrowser.getChromeDriver(browserPath);
                    break;
                }
                driver = ChromeBrowser.getChromeDriver();
                break;
            }
            case IE: {
                driver = IeBrowser.createIeDriver(browserPath, browserConfig);
                break;
            }
            case HTMLUNIT_NOJS: {
                driver = WebDriverFactory.newHtmlUnitDriver(false);
                break;
            }
            case HTMLUNIT: {
                driver = WebDriverFactory.newHtmlUnitDriver(true);
                break;
            }
            case IPHONE_SIMULATOR: {
                throw new UnsupportedOperationException("iPhone simulator is no longer a supported Browser Type. Use remote iPhone driver instead");
            }
            case IPHONE: {
                throw new RuntimeException("iPhone driver must be configured with a url parameter");
            }
            case IPAD: {
                throw new RuntimeException("iPad driver must be configured with a url parameter");
            }
            case ANDROID_EMULATOR: {
                throw new UnsupportedOperationException("Android emulator is no longer a supported Browser Type. Use remote Android driver instead");
            }
            case ANDROID: {
                throw new RuntimeException("Android driver must be configured with a url parameter");
            }
            case SAFARI: {
                throw new UnsupportedOperationException("Safari is not a supported Browser Type");
            }
            case OPERA: {
                throw new UnsupportedOperationException("Opera is not a supported Browser Type");
            }
            default: {
                log.error("Unknown browser: {}, defaulting to firefox.", (Object)BROWSER);
                browserType = Browser.FIREFOX;
                driver = FirefoxBrowser.getFirefoxDriver();
            }
        }
        BrowserUtil.setCurrentBrowser((Browser)browserType);
        return new DefaultAtlassianWebDriver((WebDriver)driver, browserType);
    }

    private static HtmlUnitDriver newHtmlUnitDriver(boolean javascriptEnabled) {
        HtmlUnitDriver driver = new HtmlUnitDriver(BrowserVersion.FIREFOX_38){

            protected WebClient modifyWebClient(WebClient client) {
                client.getOptions().setThrowExceptionOnScriptError(false);
                return client;
            }
        };
        driver.setJavascriptEnabled(javascriptEnabled);
        return driver;
    }
}

