/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.utils.Check;
import com.atlassian.webdriver.utils.element.ElementIsVisible;
import com.atlassian.webdriver.utils.element.ElementLocated;
import com.atlassian.webdriver.utils.element.ElementNotLocated;
import com.atlassian.webdriver.utils.element.ElementNotVisible;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.HasCapabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.HasInputDevices;
import org.openqa.selenium.interactions.Keyboard;
import org.openqa.selenium.interactions.Mouse;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAtlassianWebDriver
implements AtlassianWebDriver {
    private static final Logger log = LoggerFactory.getLogger(DefaultAtlassianWebDriver.class);
    private static final int WAIT_TIME = 60;
    private final WebDriver driver;
    private final Browser browser;

    @Inject
    public DefaultAtlassianWebDriver(WebDriver driver, Browser browser) {
        this.driver = (WebDriver)Preconditions.checkNotNull((Object)driver, (Object)"driver");
        this.browser = (Browser)Preconditions.checkNotNull((Object)browser, (Object)"browser");
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public WebDriver getWrappedDriver() {
        return this.driver;
    }

    @Override
    public WebDriver getDriver() {
        return this.driver;
    }

    @Override
    public void quit() {
        RemoteWebDriver remoteDriver;
        log.debug("Quitting {}", (Object)this);
        if (this.driver instanceof RemoteWebDriver && (remoteDriver = (RemoteWebDriver)this.driver).getSessionId() == null) {
            log.debug("No remote session {}", (Object)this);
            return;
        }
        this.driver.quit();
        log.debug("Quit complete {}", (Object)this);
    }

    @Override
    public void waitUntil(Function<WebDriver, Boolean> isTrue) {
        new WebDriverWait(this.getDriver(), 60L).until(isTrue);
    }

    @Override
    public void waitUntil(Function<WebDriver, Boolean> isTrue, int timeoutInSeconds) {
        new WebDriverWait(this.getDriver(), (long)timeoutInSeconds).until(isTrue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dumpSourceTo(File dumpFile) {
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(dumpFile);
            IOUtils.write((String)this.getDriver().getPageSource(), (Writer)fileWriter);
        }
        catch (IOException e1) {
            try {
                log.info("Error dumping page source to file: " + dumpFile + " : " + e1.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    @Override
    public void takeScreenshotTo(File destFile) {
        if (this.getDriver() instanceof TakesScreenshot) {
            TakesScreenshot shotter = (TakesScreenshot)this.getDriver();
            log.info("Saving screenshot to: " + destFile.getAbsolutePath());
            try {
                File screenshot = (File)shotter.getScreenshotAs(OutputType.FILE);
                FileUtils.copyFile((File)screenshot, (File)destFile);
            }
            catch (IOException e) {
                log.warn("Could not capture screenshot to: " + destFile, (Throwable)e);
            }
            catch (WebDriverException e) {
                log.debug("Details: ", (Throwable)e);
            }
        } else {
            log.info("Driver is not capable of taking screenshots.");
        }
    }

    @Override
    public void waitUntilElementIsVisibleAt(By elementLocator, SearchContext at) {
        this.waitUntil((Function<WebDriver, Boolean>)new ElementIsVisible(elementLocator, at));
    }

    @Override
    public void waitUntilElementIsVisible(By elementLocator) {
        this.waitUntilElementIsVisibleAt(elementLocator, null);
    }

    @Override
    public void waitUntilElementIsNotVisibleAt(By elementLocator, SearchContext at) {
        this.waitUntil((Function<WebDriver, Boolean>)new ElementNotVisible(elementLocator, at));
    }

    @Override
    public void waitUntilElementIsNotVisible(By elementLocator) {
        this.waitUntilElementIsNotVisibleAt(elementLocator, null);
    }

    @Override
    public void waitUntilElementIsLocatedAt(By elementLocator, SearchContext at) {
        this.waitUntil((Function<WebDriver, Boolean>)new ElementLocated(elementLocator, at));
    }

    @Override
    public void waitUntilElementIsLocated(By elementLocator) {
        this.waitUntilElementIsLocatedAt(elementLocator, null);
    }

    @Override
    public void waitUntilElementIsNotLocatedAt(By elementLocator, SearchContext at) {
        this.waitUntil((Function<WebDriver, Boolean>)new ElementNotLocated(elementLocator, at));
    }

    @Override
    public void waitUntilElementIsNotLocated(By elementLocator) {
        this.waitUntilElementIsNotLocatedAt(elementLocator, null);
    }

    @Override
    public boolean elementExists(By locator) {
        return Check.elementExists(locator, (SearchContext)this.driver);
    }

    @Override
    public boolean elementExistsAt(By locator, SearchContext context) {
        return Check.elementExists(locator, context);
    }

    @Override
    public boolean elementIsVisible(By locator) {
        return Check.elementIsVisible(locator, (SearchContext)this.driver);
    }

    @Override
    public boolean elementIsVisibleAt(By locator, SearchContext context) {
        return Check.elementIsVisible(locator, context);
    }

    public void get(String url) {
        this.driver.get(url);
    }

    public String getCurrentUrl() {
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        return this.driver.getTitle();
    }

    public List<WebElement> findElements(By by) {
        return this.driver.findElements(by);
    }

    public WebElement findElement(By by) {
        return this.driver.findElement(by);
    }

    public String getPageSource() {
        return this.driver.getPageSource();
    }

    public void close() {
        this.driver.close();
    }

    public Set<String> getWindowHandles() {
        return this.driver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.driver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.driver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.driver.navigate();
    }

    public WebDriver.Options manage() {
        return this.driver.manage();
    }

    public Object executeScript(String script) {
        return ((JavascriptExecutor)this.driver).executeScript(script, new Object[0]);
    }

    public Object executeScript(String script, Object ... args) {
        return ((JavascriptExecutor)this.driver).executeScript(script, args);
    }

    public Object executeAsyncScript(String s, Object ... objects) {
        return ((JavascriptExecutor)this.driver).executeAsyncScript(s, objects);
    }

    public boolean isJavascriptEnabled() {
        return ((HasCapabilities)this.driver).getCapabilities().isJavascriptEnabled();
    }

    public Keyboard getKeyboard() {
        return ((HasInputDevices)this.driver).getKeyboard();
    }

    public Mouse getMouse() {
        return ((HasInputDevices)this.driver).getMouse();
    }
}

