/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.element;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.junit.internal.matchers.TypeSafeMatcher;
import org.openqa.selenium.WebElement;

public final class WebElementMatchers {
    private WebElementMatchers() {
        throw new AssertionError((Object)"Don't instantiate me");
    }

    public static <T> Matcher<Iterable<T>> containsAtLeast(final Matcher<T> elementMatcher, final int numberOfMatchingItems) {
        return new TypeSafeMatcher<Iterable<T>>(){

            public boolean matchesSafely(Iterable<T> elements) {
                if (Iterables.size(elements) < numberOfMatchingItems) {
                    return false;
                }
                int matchCount = 0;
                for (Object item : elements) {
                    if (!elementMatcher.matches(item)) continue;
                    ++matchCount;
                }
                return matchCount >= numberOfMatchingItems;
            }

            public void describeTo(Description description) {
                description.appendText("Contains at least ").appendValue((Object)numberOfMatchingItems).appendText(" items matching ").appendDescriptionOf((SelfDescribing)elementMatcher);
            }
        };
    }

    public static Matcher<WebElement> tagNameEqual(final String expectedTagName) {
        Preconditions.checkNotNull((Object)expectedTagName);
        return new TypeSafeMatcher<WebElement>(){

            public boolean matchesSafely(WebElement item) {
                return expectedTagName.equals(item.getTagName());
            }

            public void describeTo(Description description) {
                description.appendText("Tag name should be equal to ").appendValue((Object)expectedTagName);
            }
        };
    }
}

