/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils.element;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

public final class WebDriverPoller {
    public static final long DEFAULT_TIMEOUT = 30L;
    public static final TimeUnit DEFAULT_TIMEOUT_UNIT = TimeUnit.SECONDS;
    private final WebDriver webDriver;
    private final TimeUnit timeUnit;
    private final long timeout;

    @Inject
    public WebDriverPoller(@Nonnull WebDriver webDriver) {
        this(webDriver, 30L, DEFAULT_TIMEOUT_UNIT);
    }

    public WebDriverPoller(@Nonnull WebDriver webDriver, long timeout, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"Timeout must be >0");
        this.webDriver = (WebDriver)Preconditions.checkNotNull((Object)webDriver, (Object)"webDriver");
        this.timeout = timeout;
        this.timeUnit = (TimeUnit)((Object)Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"timeUnit"));
    }

    public WebDriverPoller withDefaultTimeout(long timeout, TimeUnit timeUnit) {
        return new WebDriverPoller(this.webDriver, timeout, timeUnit);
    }

    public void waitUntil(Function<WebDriver, Boolean> condition) {
        this.waitUntil(condition, this.timeout, this.timeUnit);
    }

    public void waitUntil(Function<WebDriver, Boolean> condition, long timeoutInSeconds) {
        new WebDriverWait(this.webDriver, timeoutInSeconds).until(condition);
    }

    public void waitUntil(Function<WebDriver, Boolean> condition, long timeout, TimeUnit unit) {
        this.waitUntil(condition, unit.toSeconds(timeout));
    }
}

