/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.internal.WrapsDriver;

public final class WebDriverUtil {
    private WebDriverUtil() {
        throw new AssertionError((Object)(WebDriverUtil.class.getName() + " is not supposed to be instantiated"));
    }

    public static boolean isFirefox(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof FirefoxDriver;
    }

    public static boolean isChrome(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof ChromeDriver;
    }

    public static boolean isHtmlUnit(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof HtmlUnitDriver;
    }

    public static boolean isIE(@Nonnull WebDriver driver) {
        return WebDriverUtil.getUnderlyingDriver(driver) instanceof InternetExplorerDriver;
    }

    @Nonnull
    public static WebDriver getUnderlyingDriver(@Nonnull WebDriver driver) {
        Preconditions.checkNotNull((Object)driver, (Object)"driver");
        while (driver instanceof WrapsDriver) {
            driver = ((WrapsDriver)WrapsDriver.class.cast(driver)).getWrappedDriver();
        }
        return driver;
    }

    public static boolean isInstance(@Nonnull WebDriver driver, @Nonnull Class<?> type) {
        return type.isInstance(WebDriverUtil.getUnderlyingDriver(driver));
    }

    public static <T> T as(@Nonnull WebDriver driver, @Nonnull Class<T> type) {
        return type.cast(WebDriverUtil.getUnderlyingDriver(driver));
    }
}

