/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.utils;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.WebElement;

public final class Check {
    private Check() {
        throw new AssertionError((Object)(Check.class.getName() + " is not supposed to be instantiated"));
    }

    public static boolean elementExists(By by, SearchContext el) {
        try {
            el.findElement(by);
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public static boolean elementIsVisible(By by, SearchContext context) {
        try {
            WebElement lookFor = context.findElement(by);
            return Check.isVisible(lookFor);
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public static boolean elementsAreVisible(By by, SearchContext context) {
        List elements = context.findElements(by);
        if (elements.size() > 0) {
            for (WebElement lookFor : elements) {
                if (Check.isVisible(lookFor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isVisible(WebElement webElement) {
        try {
            return webElement.isDisplayed();
        }
        catch (StaleElementReferenceException e) {
            return false;
        }
    }

    public static boolean hasClass(String className, WebElement element) {
        String classNameLowerCase = className.toLowerCase();
        String classValue = element.getAttribute("class");
        if (StringUtils.isEmpty((String)classValue)) {
            return false;
        }
        if (!(classValue = classValue.toLowerCase()).contains(classNameLowerCase)) {
            return false;
        }
        for (String singleClass : classValue.split("\\s+")) {
            if (!classNameLowerCase.equals(singleClass)) continue;
            return true;
        }
        return false;
    }
}

