/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.browsers.WebDriverBrowserAutoInstall;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import javax.inject.Inject;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogPageSourceRule
extends TestWatcher {
    private static final Logger DEFAULT_LOGGER = LoggerFactory.getLogger(LogPageSourceRule.class);
    private static final String ENABLE_LOG_KEY = "atlassian.test.logSourceOnFailure";
    private final Logger logger;
    private final Supplier<? extends WebDriver> webDriver;

    @Inject
    public LogPageSourceRule(WebDriver webDriver, Logger logger) {
        this((Supplier<? extends WebDriver>)Suppliers.ofInstance((Object)Preconditions.checkNotNull((Object)webDriver, (Object)"webDriver")), logger);
    }

    public LogPageSourceRule(Supplier<? extends WebDriver> webDriver, Logger logger) {
        this.webDriver = (Supplier)Preconditions.checkNotNull(webDriver, (Object)"webDriver");
        this.logger = (Logger)Preconditions.checkNotNull((Object)logger, (Object)"logger");
    }

    public LogPageSourceRule(Logger logger) {
        this(WebDriverBrowserAutoInstall.driverSupplier(), logger);
    }

    public LogPageSourceRule() {
        this(DEFAULT_LOGGER);
    }

    public void failed(Throwable e, Description description) {
        if (!this.logPageSourceEnabled()) {
            return;
        }
        this.logger.info("----- Test '{}' Failed. ", (Object)description.getMethodName());
        this.logger.info("----- START PAGE SOURCE DUMP\n\n\n{}\n\n\n", (Object)((WebDriver)this.webDriver.get()).getPageSource());
        this.logger.info("----- END PAGE SOURCE DUMP");
    }

    private boolean logPageSourceEnabled() {
        return Boolean.TRUE.toString().equals(System.getProperty(ENABLE_LOG_KEY));
    }
}

