/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.webdriver.LifecycleAwareWebDriverGrid;
import java.util.Iterator;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

@ThreadSafe
public class DriverCleanupRule
extends TestWatcher {
    private static final Timer KILLER_TIMER = new Timer("Atlassian-BrowserKiller", true);
    private static final Queue<TimerTask> KILLER_TASKS = new ConcurrentLinkedQueue<TimerTask>();
    private final long timeout;
    private final TimeUnit timeUnit;

    public DriverCleanupRule(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public DriverCleanupRule() {
        this(3L, TimeUnit.SECONDS);
    }

    protected void starting(Description description) {
        Iterator tasks = KILLER_TASKS.iterator();
        while (tasks.hasNext()) {
            ((TimerTask)tasks.next()).cancel();
            tasks.remove();
        }
    }

    protected void finished(Description description) {
        BrowserKiller newKiller = new BrowserKiller();
        KILLER_TASKS.add(newKiller);
        KILLER_TIMER.schedule((TimerTask)newKiller, this.timeUnit.toMillis(this.timeout));
    }

    private static final class BrowserKiller
    extends TimerTask {
        private BrowserKiller() {
        }

        @Override
        public void run() {
            LifecycleAwareWebDriverGrid.shutdown();
        }
    }
}

