/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.testing.rule;

import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.inject.InjectionContext;
import com.atlassian.pageobjects.util.InjectingTestedProducts;
import com.atlassian.webdriver.testing.rule.InjectingTestRule;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class ClassInjectionRule<P extends TestedProduct<?>>
implements InjectingTestRule {
    private final Supplier<P> product;

    ClassInjectionRule(Supplier<P> productSupplier) {
        this.product = (Supplier)Preconditions.checkNotNull(productSupplier, (Object)"productSupplier");
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (ClassInjectionRule.this.supportsInjection()) {
                    ClassInjectionRule.this.injectionContext().injectStatic(description.getTestClass());
                }
                base.evaluate();
            }
        };
    }

    boolean supportsInjection() {
        return InjectingTestedProducts.supportsInjection((TestedProduct)((TestedProduct)this.product.get()));
    }

    InjectionContext injectionContext() {
        return InjectingTestedProducts.asInjectionContext((TestedProduct)((TestedProduct)this.product.get()));
    }

    @Nonnull
    public <T> T getInstance(@Nonnull Class<T> type) {
        return (T)this.injectionContext().getInstance(type);
    }

    public void injectStatic(@Nonnull Class<?> targetClass) {
        this.injectionContext().injectStatic(targetClass);
    }

    public void injectMembers(@Nonnull Object targetInstance) {
        this.injectionContext().injectMembers(targetInstance);
    }
}

