/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.debug;

import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebDriverDebug {
    private static final Logger log = LoggerFactory.getLogger(WebDriverDebug.class);
    private final WebDriver webDriver;

    @Inject
    public WebDriverDebug(@Nonnull WebDriver webDriver) {
        this.webDriver = (WebDriver)Preconditions.checkNotNull((Object)webDriver, (Object)"webDriver");
    }

    @Nonnull
    public String getCurrentUrl() {
        return this.webDriver.getCurrentUrl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dumpSourceTo(@Nonnull File dumpFile) {
        boolean bl;
        Preconditions.checkNotNull((Object)dumpFile, (Object)"dumpFile");
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(dumpFile);
            IOUtils.write((String)this.webDriver.getPageSource(), (Writer)fileWriter);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                log.warn("Error dumping page source to " + dumpFile.getAbsolutePath() + ": " + e.getMessage());
                log.debug("Error dumping page source - details", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        return bl;
    }

    public boolean dumpPageSourceTo(@Nonnull Writer writer) {
        Preconditions.checkNotNull((Object)writer, (Object)"writer");
        try {
            IOUtils.write((String)this.webDriver.getPageSource(), (Writer)writer);
            return true;
        }
        catch (IOException e) {
            log.warn("Error dumping page source to " + writer + ": " + e.getMessage());
            log.debug("Error dumping page source - details", (Throwable)e);
            return false;
        }
    }

    public boolean takeScreenshotTo(@Nonnull File destFile) {
        if (WebDriverUtil.isInstance(this.webDriver, TakesScreenshot.class)) {
            TakesScreenshot shotter = WebDriverUtil.as(this.webDriver, TakesScreenshot.class);
            log.info("Saving screenshot to: " + destFile.getAbsolutePath());
            try {
                File screenshot = (File)shotter.getScreenshotAs(OutputType.FILE);
                FileUtils.copyFile((File)screenshot, (File)destFile);
                return true;
            }
            catch (IOException e) {
                this.logScreenshotError(destFile, e);
            }
            catch (WebDriverException e) {
                this.logScreenshotError(destFile, (Exception)((Object)e));
            }
        } else {
            log.warn("Driver {} is not capable of taking screenshots.", (Object)this.webDriver);
        }
        return false;
    }

    private void logScreenshotError(File destFile, Exception e) {
        log.warn("Could not capture screenshot to {}: {}", (Object)destFile, (Object)e.getMessage());
        log.debug("Capture screenshot - error details", (Throwable)e);
    }
}

