/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.browsers.profile;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.LineReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriverException;

public class ProfilePreferences {
    private final Pattern PREFERENCE_PATTERN = Pattern.compile("^([^=]+)=(.*)$");
    private final Map<String, Object> allPreferences = Maps.newHashMap();

    public ProfilePreferences(File preferencesFile) {
        FileReader reader = null;
        try {
            reader = new FileReader(preferencesFile);
            this.readPreferences(reader);
        }
        catch (IOException e) {
            try {
                throw new WebDriverException((Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
    }

    public Map<String, Object> getPreferences() {
        return ImmutableMap.copyOf(this.allPreferences);
    }

    private void readPreferences(FileReader reader) throws IOException {
        LineReader allLines = new LineReader((Readable)reader);
        String line = allLines.readLine();
        while (line != null) {
            Matcher matcher = this.PREFERENCE_PATTERN.matcher(line);
            if (matcher.matches()) {
                this.allPreferences.put(matcher.group(1), this.preferenceAsValue(matcher.group(2)));
            }
            line = allLines.readLine();
        }
    }

    private Object preferenceAsValue(String value) {
        if ("false".equals(value) || "true".equals(value)) {
            return Boolean.parseBoolean(value);
        }
        if (value.matches("^[0-9]+$")) {
            return Integer.parseInt(value);
        }
        return value;
    }
}

