/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver;

import com.atlassian.browsers.BrowserConfig;
import com.atlassian.pageobjects.browser.Browser;
import com.atlassian.pageobjects.util.BrowserUtil;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.atlassian.webdriver.DefaultAtlassianWebDriver;
import com.atlassian.webdriver.RemoteWebDriverFactory;
import com.atlassian.webdriver.browsers.chrome.ChromeBrowser;
import com.atlassian.webdriver.browsers.firefox.FirefoxBrowser;
import com.atlassian.webdriver.browsers.ie.IeBrowser;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.iphone.IPhoneSimulatorBinary;
import org.openqa.selenium.iphone.IPhoneSimulatorDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverFactory {
    private static final Logger log = LoggerFactory.getLogger(WebDriverFactory.class);
    private static final Pattern browserPathPattern = Pattern.compile("^([A-Za-z0-9_.-]+):path=(.*)$");

    private WebDriverFactory() {
    }

    public static AtlassianWebDriver getDriver() {
        return WebDriverFactory.getDriver(null);
    }

    public static String getBrowserProperty() {
        return System.getProperty("webdriver.browser", "firefox");
    }

    public static Browser getBrowser() {
        String browserProperty = WebDriverFactory.getBrowserProperty();
        return WebDriverFactory.getBrowser(browserProperty);
    }

    public static Browser getBrowser(String browserProperty) {
        if (RemoteWebDriverFactory.matches(browserProperty)) {
            return RemoteWebDriverFactory.getBrowser(browserProperty);
        }
        Matcher matcher = browserPathPattern.matcher(browserProperty);
        if (matcher.matches()) {
            browserProperty = matcher.group(1);
        }
        Browser browserType = Browser.typeOf((String)browserProperty);
        return browserType;
    }

    public static AtlassianWebDriver getDriver(BrowserConfig browserConfig) {
        InternetExplorerDriver driver;
        String browserPath = null;
        String BROWSER = WebDriverFactory.getBrowserProperty();
        if (RemoteWebDriverFactory.matches(BROWSER)) {
            return RemoteWebDriverFactory.getDriver(BROWSER, browserConfig);
        }
        Matcher matcher = browserPathPattern.matcher(BROWSER);
        if (matcher.matches()) {
            BROWSER = matcher.group(1);
            browserPath = matcher.group(2);
        }
        Browser browserType = Browser.typeOf((String)BROWSER);
        switch (browserType) {
            case FIREFOX: {
                if (browserPath == null && browserConfig != null) {
                    driver = FirefoxBrowser.getFirefoxDriver(browserConfig);
                    break;
                }
                if (browserPath != null) {
                    driver = FirefoxBrowser.getFirefoxDriver(browserPath);
                    break;
                }
                driver = FirefoxBrowser.getFirefoxDriver();
                break;
            }
            case CHROME: {
                if (browserPath == null && browserConfig != null) {
                    driver = ChromeBrowser.getChromeDriver(browserConfig);
                    break;
                }
                if (browserPath != null) {
                    driver = ChromeBrowser.getChromeDriver(browserPath);
                    break;
                }
                driver = ChromeBrowser.getChromeDriver();
                break;
            }
            case IE: {
                driver = IeBrowser.createIeDriver(browserPath, browserConfig);
                break;
            }
            case HTMLUNIT_NOJS: {
                driver = new HtmlUnitDriver(BrowserVersion.FIREFOX_3_6);
                ((HtmlUnitDriver)driver).setJavascriptEnabled(false);
                break;
            }
            case HTMLUNIT: {
                driver = new HtmlUnitDriver(BrowserVersion.FIREFOX_3_6);
                ((HtmlUnitDriver)driver).setJavascriptEnabled(true);
                break;
            }
            case IPHONE_SIMULATOR: {
                if (browserPath == null) {
                    throw new RuntimeException("iPhone simulator driver must be configured with a path parameter");
                }
                try {
                    IPhoneSimulatorBinary binary = new IPhoneSimulatorBinary(new File(browserPath));
                    driver = new IPhoneSimulatorDriver(binary);
                    break;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unable to configure iPhone simulator driver", e);
                }
            }
            case IPHONE: {
                throw new RuntimeException("iPhone driver must be configured with a url parameter");
            }
            case IPAD: {
                throw new RuntimeException("iPad driver must be configured with a url parameter");
            }
            case ANDROID_EMULATOR: {
                driver = new AndroidDriver();
                break;
            }
            case ANDROID: {
                driver = new AndroidDriver();
                break;
            }
            case SAFARI: {
                throw new UnsupportedOperationException("Safari is not a supported Browser Type");
            }
            case OPERA: {
                throw new UnsupportedOperationException("Opera is not a supported Browser Type");
            }
            default: {
                log.error("Unknown browser: {}, defaulting to firefox.", (Object)BROWSER);
                browserType = Browser.FIREFOX;
                driver = new FirefoxDriver();
            }
        }
        BrowserUtil.setCurrentBrowser((Browser)browserType);
        return new DefaultAtlassianWebDriver((WebDriver)driver, browserType);
    }
}

