/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.AbstractSeleniumConfiguration;

public class SystemPropertySeleniumConfiguration
extends AbstractSeleniumConfiguration {
    protected String serverLocation;
    protected int serverPort = 4444;
    protected String browserStartString;
    protected boolean startSeleniumServer;
    protected boolean useSingleBrowser;
    protected String appLocation;
    protected String appPort;
    protected String appContext;

    protected SystemPropertySeleniumConfiguration(String selServerLocationProp, String seleniumServerLocationDefault, String selServerPortProp, int selServerPortDefault, String selStartServerProp, boolean startServerDefault, String appLocationProp, String appLocationDefault, String appPortProp, String appPortDefault, String appContextProp, String appContextDefault) {
        String startSeleniumServerStr;
        this.serverLocation = System.getProperty(selServerLocationProp, seleniumServerLocationDefault);
        String serverPortStr = System.getProperty(selServerPortProp, Integer.toString(selServerPortDefault));
        if (!SystemPropertySeleniumConfiguration.nullOrEmpty(serverPortStr)) {
            this.serverPort = Integer.parseInt(serverPortStr);
        }
        if (SystemPropertySeleniumConfiguration.nullOrEmpty(startSeleniumServerStr = System.getProperty(selStartServerProp, Boolean.toString(startServerDefault)))) {
            this.startSeleniumServer = Boolean.parseBoolean(startSeleniumServerStr);
        }
        this.browserStartString = System.getProperty("seleniumBrowserStartString", "*firefox");
        String useSingleBrowserStr = System.getProperty("seleniumStartServer", "false");
        if (SystemPropertySeleniumConfiguration.nullOrEmpty(useSingleBrowserStr)) {
            this.useSingleBrowser = Boolean.parseBoolean(useSingleBrowserStr);
        }
        this.appLocation = System.getProperty(appLocationProp, appLocationDefault);
        this.appPort = System.getProperty(appPortProp, appPortDefault);
        this.appContext = System.getProperty(appContextProp, appContextDefault);
    }

    private static boolean nullOrEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public String getServerLocation() {
        return this.serverLocation;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public String getBrowserStartString() {
        return this.browserStartString;
    }

    public String getBaseUrl() {
        return "http://" + this.appLocation + ":" + this.appPort + "/" + this.appContext;
    }

    public boolean getStartSeleniumServer() {
        return this.startSeleniumServer;
    }

    public String getApplicationContext() {
        return this.appContext;
    }
}

