/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.Browser;
import com.atlassian.selenium.HtmlDumpingHttpCommandProcessor;
import com.atlassian.selenium.SeleniumClient;
import com.atlassian.selenium.SeleniumConfiguration;
import com.thoughtworks.selenium.CommandProcessor;
import com.thoughtworks.selenium.DefaultSelenium;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class SingleBrowserSeleniumClient
extends DefaultSelenium
implements SeleniumClient {
    private Browser browser;
    protected final long PAGE_LOAD_WAIT;
    protected final long ACTION_WAIT;

    public SingleBrowserSeleniumClient(SeleniumConfiguration config) {
        super((CommandProcessor)new HtmlDumpingHttpCommandProcessor(config.getServerLocation(), config.getServerPort(), config.getBrowserStartString(), config.getBaseUrl()));
        this.PAGE_LOAD_WAIT = config.getPageLoadWait();
        this.ACTION_WAIT = config.getActionWait();
        this.browser = Browser.typeOf(config.getBrowserStartString());
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void open(String url) {
        this.open(url, this.PAGE_LOAD_WAIT);
    }

    public void openNoWait(String url) {
        super.open(url);
    }

    public void open(String url, long timeoutMillis) {
        super.open(url);
        super.waitForPageToLoad(String.valueOf(timeoutMillis));
    }

    public void waitForPageToLoad(long timeoutMillis) {
        super.waitForPageToLoad(String.valueOf(timeoutMillis));
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(this.PAGE_LOAD_WAIT);
    }

    public void waitForCondition(String javascript) {
        this.waitForCondition(javascript, this.ACTION_WAIT);
    }

    public void waitForCondition(String javascript, long timeoutMillis) {
        this.waitForCondition(javascript, Long.toString(timeoutMillis));
    }

    public void waitForAjaxWithJquery() {
        this.waitForAjaxWithJquery(this.ACTION_WAIT);
    }

    public void waitForAjaxWithJquery(long timeoutMillis) {
        if (!this.hasJquery()) {
            throw new UnsupportedOperationException("This operation requires jQuery.");
        }
        this.waitForCondition("selenium.browserbot.getCurrentWindow().jQuery.active == 0;", Long.toString(timeoutMillis));
    }

    public void click(String locator, boolean waitForPageToLoad) {
        super.click(locator);
        if (waitForPageToLoad) {
            super.waitForPageToLoad(String.valueOf(this.PAGE_LOAD_WAIT));
        }
    }

    public void submit(String form, boolean waitForPageToLoad) {
        super.submit(form);
        if (waitForPageToLoad) {
            super.waitForPageToLoad(String.valueOf(this.PAGE_LOAD_WAIT));
        }
    }

    public void click(String locator, long timeoutMillis) {
        super.click(locator);
        super.waitForPageToLoad(Long.toString(timeoutMillis));
    }

    public void clickAndWaitForAjaxWithJquery(String locator) {
        super.click(locator);
        this.waitForAjaxWithJquery();
    }

    public void clickAndWaitForAjaxWithJquery(String locator, long timeoutMillis) {
        super.click(locator);
        this.waitForAjaxWithJquery(timeoutMillis);
    }

    public void submit(String form, long timeoutMillis) {
        super.submit(form);
        super.waitForPageToLoad(Long.toString(timeoutMillis));
    }

    public void keyPress(String locator, String key) {
        super.keyDown(locator, key);
        super.keyPress(locator, key);
        super.keyUp(locator, key);
    }

    public void typeWithFullKeyEvents(String locator, String string, boolean reset) {
        super.focus(locator);
        if (reset) {
            super.type(locator, "");
        }
        if (Browser.FIREFOX.equals((Object)this.browser)) {
            char[] chars;
            for (char aChar : chars = string.toCharArray()) {
                super.focus(locator);
                this.keyPress(locator, "\\" + aChar);
            }
        } else {
            if (!reset) {
                string = super.getValue(locator) + string;
            }
            super.type(locator, string);
            super.typeKeys(locator, string);
        }
    }

    public void typeWithFullKeyEvents(String locator, String string) {
        this.typeWithFullKeyEvents(locator, string, true);
    }

    public void selectOption(String selectName, String label) {
        int i;
        String[] options = super.getSelectOptions(selectName);
        for (i = 0; i < options.length && !options[i].trim().equals(label); ++i) {
        }
        if (i < options.length) {
            super.select(selectName, options[i]);
        }
    }

    public void selectOptionAndWaitForAjaxWithJquery(String selectName, String label) {
        this.selectOption(selectName, label);
        this.waitForAjaxWithJquery();
    }

    public void check(String name, String value) {
        this.check("name=" + name + " value=" + value);
    }

    public void clickLinkWithText(String text, boolean waitForPageToLoad) {
        super.click("link=" + text);
        if (waitForPageToLoad) {
            this.waitForPageToLoad();
        }
    }

    public void clickButton(String buttonText, boolean waitForPageToLoad) {
        this.clickElementWithXpath("//input[@value = '" + buttonText + "']");
        if (waitForPageToLoad) {
            this.waitForPageToLoad();
        }
    }

    public void clickButtonAndWaitForAjaxWithJquery(String buttonText) {
        this.clickButton(buttonText, false);
        this.waitForAjaxWithJquery();
    }

    public void clickButtonWithName(String buttonName, boolean waitForPageToLoad) {
        this.clickElementWithXpath("//input[@name = '" + buttonName + "']");
        if (waitForPageToLoad) {
            this.waitForPageToLoad();
        }
    }

    public void clickButtonWithNameAndWaitForAjaxWithJquery(String buttonName) {
        this.clickButtonWithName(buttonName, false);
        this.waitForAjaxWithJquery();
    }

    public void clickElementWithTitle(String title) {
        super.click("xpath=//*[@title='" + title + "']");
    }

    public void clickElementWithTitleAndWaitForAjaxWithJquery(String title) {
        this.clickElementWithTitle(title);
        this.waitForAjaxWithJquery();
    }

    public void clickElementWithClass(String className) {
        super.click("css=." + className);
    }

    public void clickElementWithClassAndWaitForAjaxWithJquery(String className) {
        this.clickElementWithClass(className);
        this.waitForAjaxWithJquery();
    }

    public void clickElementWithCss(String cssSelector) {
        super.click("css=" + cssSelector);
    }

    public void clickElementWithCssAndWaitForAjaxWithJquery(String cssSelector) {
        this.clickElementWithCss(cssSelector);
        this.waitForAjaxWithJquery();
    }

    public void clickElementWithXpath(String xpath) {
        super.click("xpath=" + xpath);
    }

    public void clickElementWithXpathAndWaitForAjaxWithJquery(String xpath) {
        this.clickElementWithXpath(xpath);
        this.waitForAjaxWithJquery();
    }

    public void typeInElementWithName(String elementName, String text) {
        super.type("name=" + elementName, text);
    }

    public void typeInElementWithCss(String cssSelector, String text) {
        super.type("css=" + cssSelector, text);
    }

    public boolean hasJquery() {
        String evalJquery = this.getEval("selenium.browserbot.getCurrentWindow().jQuery");
        return evalJquery != null && !"null".equals(evalJquery) && !"undefined".equals(evalJquery);
    }

    private void addJqueryLocator() throws IOException {
        String jqueryImpl = SingleBrowserSeleniumClient.readFile("jquery-1.3.1.min.js");
        String jqueryLocStrategy = SingleBrowserSeleniumClient.readFile("jquery-locationStrategy.js");
        this.addScript(jqueryImpl, "jquery");
        this.addLocationStrategy("jquery", jqueryLocStrategy);
    }

    private static String readFile(String file) throws IOException {
        InputStream stream = SingleBrowserSeleniumClient.class.getClassLoader().getResourceAsStream(file);
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String line = reader.readLine();
        StringBuffer contents = new StringBuffer();
        while (line != null) {
            contents.append(line).append("\n");
            line = reader.readLine();
        }
        return contents.toString();
    }

    public void start() {
        super.start();
        try {
            this.addJqueryLocator();
        }
        catch (IOException ioe) {
            System.err.println("Unable to load JQuery locator strategy: " + ioe);
            ioe.printStackTrace(System.err);
        }
    }
}

