/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.Condition;
import com.atlassian.selenium.Conditions;
import com.atlassian.selenium.SeleniumConfiguration;
import com.atlassian.selenium.pageobjects.PageElement;
import com.thoughtworks.selenium.Selenium;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.log4j.Logger;

public class SeleniumAssertions {
    private static final Logger log = Logger.getLogger(SeleniumAssertions.class);
    private final Selenium client;
    private final long conditionCheckInterval;
    private final long defaultMaxWait;

    public SeleniumAssertions(Selenium client, SeleniumConfiguration config) {
        this.client = client;
        this.conditionCheckInterval = config.getConditionCheckInterval();
        this.defaultMaxWait = config.getActionWait();
    }

    public void visibleByTimeout(String locator) {
        this.byTimeout(Conditions.isVisible(locator));
    }

    public void visibleByTimeout(PageElement element) {
        this.visibleByTimeout(element.getLocator());
    }

    public void visibleByTimeout(String locator, long maxMillis) {
        this.byTimeout(Conditions.isVisible(locator), maxMillis);
    }

    public void visibleByTimeout(PageElement element, long maxMillis) {
        this.visibleByTimeout(element.getLocator(), maxMillis);
    }

    public void notVisibleByTimeout(String locator) {
        this.byTimeout(Conditions.isNotVisible(locator));
    }

    public void notVisibleByTimeout(PageElement element) {
        this.notVisibleByTimeout(element.getLocator());
    }

    public void notVisibleByTimeout(String locator, long maxMillis) {
        this.byTimeout(Conditions.isNotVisible(locator), maxMillis);
    }

    public void notVisibleByTimeout(PageElement element, long maxMillis) {
        this.notVisibleByTimeout(element.getLocator(), maxMillis);
    }

    public void elementPresentByTimeout(String locator) {
        this.byTimeout(Conditions.isPresent(locator));
    }

    public void elementPresentByTimeout(PageElement element) {
        this.elementPresentByTimeout(element.getLocator());
    }

    public void elementPresentByTimeout(String locator, long maxMillis) {
        this.byTimeout(Conditions.isPresent(locator), maxMillis);
    }

    public void elementPresentByTimeout(PageElement element, long maxMillis) {
        this.elementPresentByTimeout(element.getLocator(), maxMillis);
    }

    public void elementPresentUntilTimeout(String locator) {
        this.untilTimeout(Conditions.isPresent(locator));
    }

    public void elementPresentUntilTimeout(PageElement element) {
        this.elementPresentUntilTimeout(element.getLocator());
    }

    public void elementPresentUntilTimeout(String locator, long maxMillis) {
        this.untilTimeout(Conditions.isPresent(locator), maxMillis);
    }

    public void elementPresentUntilTimeout(PageElement element, long maxMillis) {
        this.elementPresentUntilTimeout(element.getLocator(), maxMillis);
    }

    public void elementNotPresentByTimeout(String locator) {
        this.byTimeout(Conditions.isNotPresent(locator));
    }

    public void elementNotPresentByTimeout(PageElement element) {
        this.elementNotPresentByTimeout(element.getLocator());
    }

    public void elementNotPresentUntilTimeout(String locator) {
        this.untilTimeout(Conditions.isNotPresent(locator));
    }

    public void elementNotPresentUntilTimeout(PageElement element) {
        this.elementNotPresentUntilTimeout(element.getLocator());
    }

    public void elementNotPresentUntilTimeout(String locator, long maxMillis) {
        this.untilTimeout(Conditions.isNotPresent(locator), maxMillis);
    }

    public void elementNotPresentUntilTimeout(PageElement element, long maxMillis) {
        this.elementNotPresentUntilTimeout(element.getLocator(), maxMillis);
    }

    public void textPresentByTimeout(String text, long maxMillis) {
        this.byTimeout(Conditions.isTextPresent(text), maxMillis);
    }

    public void textPresentByTimeout(String text) {
        this.byTimeout(Conditions.isTextPresent(text));
    }

    public void textNotPresentByTimeout(String text, long maxMillis) {
        this.byTimeout(Conditions.isTextNotPresent(text), maxMillis);
    }

    public void textNotPresentByTimeout(String text) {
        this.byTimeout(Conditions.isTextNotPresent(text));
    }

    public void elementNotPresentByTimeout(String locator, long maxMillis) {
        this.byTimeout(Conditions.isNotPresent(locator), maxMillis);
    }

    public void elementNotPresentByTimeout(PageElement element, long maxMillis) {
        this.elementNotPresentByTimeout(element.getLocator(), maxMillis);
    }

    public void byTimeout(Condition condition) {
        this.byTimeout(condition, this.defaultMaxWait);
    }

    public void byTimeout(Condition condition, long maxWaitTime) {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - startTime >= maxWaitTime) {
                log.error((Object)("Page source:\n" + this.client.getHtmlSource()));
                throw new AssertionError((Object)("Waited " + maxWaitTime + " ms for [" + condition.errorMessage() + "], but it never became true."));
            }
            if (condition.executeTest(this.client)) break;
            try {
                Thread.sleep(this.conditionCheckInterval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was interupted", e);
            }
        }
    }

    public void untilTimeout(Condition condition) {
        this.untilTimeout(condition, this.defaultMaxWait);
    }

    public void untilTimeout(Condition condition, long maxWaitTime) {
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < maxWaitTime) {
            if (!condition.executeTest(this.client)) {
                log.error((Object)("Page source:\n" + this.client.getHtmlSource()));
                throw new AssertionError((Object)("Condition [" + condition.errorMessage() + "], became before timeout."));
            }
            try {
                Thread.sleep(this.conditionCheckInterval);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Thread was interupted", e);
            }
        }
    }

    public void textPresent(String text) {
        Assert.assertTrue((String)("Expected text not found in response: '" + text + "'"), (boolean)this.client.isTextPresent(text));
    }

    public void textNotPresent(String text) {
        Assert.assertFalse((String)("Un-expected text found in response: '" + text + "'"), (boolean)this.client.isTextPresent(text));
    }

    public void formElementEquals(String locator, String value) {
        Assert.assertEquals((String)("Element with id '" + locator + "' did not have the expected value '" + value + "'"), (String)value, (String)this.client.getValue(locator));
    }

    public void elementPresent(String locator) {
        Assert.assertTrue((String)("Expected element not found in response: '" + locator + "'"), (boolean)this.client.isElementPresent(locator));
    }

    public void elementPresent(PageElement element) {
        this.elementPresent(element.getLocator());
    }

    public void elementNotPresent(String locator) {
        Assert.assertFalse((String)("Un-expected element found in response: '" + locator + "'"), (boolean)this.client.isElementPresent(locator));
    }

    public void elementNotPresent(PageElement element) {
        this.elementNotPresent(element.getLocator());
    }

    public void elementVisible(String locator) {
        Assert.assertTrue((String)("Expected element not visible in response: '" + locator + "'"), (this.client.isElementPresent(locator) && this.client.isVisible(locator) ? 1 : 0) != 0);
    }

    public void elementVisible(PageElement element) {
        this.elementVisible(element.getLocator());
    }

    public void elementNotVisible(String locator) {
        Assert.assertFalse((String)("Un-expected element visible in response: '" + locator + "'"), (this.client.isElementPresent(locator) && this.client.isVisible(locator) ? 1 : 0) != 0);
    }

    public void elementNotVisible(PageElement element) {
        this.elementNotVisible(element.getLocator());
    }

    public void elementVisibleContainsText(String locator, String text) {
        this.elementVisible(locator);
        this.elementContainsText(locator, text);
    }

    public void elementVisibleContainsText(PageElement element, String text) {
        this.elementVisibleContainsText(element.getLocator(), text);
    }

    public void htmlPresent(String html) {
        Assert.assertTrue((String)("Expected HTML not found in response: '" + html + "'"), (this.client.getHtmlSource().toLowerCase().indexOf(html) >= 0 ? 1 : 0) != 0);
    }

    public void htmlNotPresent(String html) {
        Assert.assertFalse((String)("Unexpected HTML found in response: '" + html + "'"), (this.client.getHtmlSource().toLowerCase().indexOf(html) >= 0 ? 1 : 0) != 0);
    }

    public void elementHasText(String locator, String text) {
        Assert.assertTrue((String)("Element(s) with locator '" + locator + "' did not contain text '" + text + "'"), (this.client.getText(locator).indexOf(text) >= 0 ? 1 : 0) != 0);
    }

    public void elementHasText(PageElement element, String text) {
        this.elementHasText(element.getLocator(), text);
    }

    public void elementDoesntHaveText(String locator, String text) {
        Assert.assertFalse((String)("Element(s) with locator '" + locator + "' did contained text '" + text + "'"), (this.client.getText(locator).indexOf(text) >= 0 ? 1 : 0) != 0);
    }

    public void elementDoesntHaveText(PageElement element, String text) {
        this.elementDoesntHaveText(element.getLocator(), text);
    }

    public void attributeContainsValue(String locator, String attribute, String value) {
        String attributeValue = this.client.getAttribute(locator + "@" + attribute);
        Assert.assertTrue((String)("Element with locator '" + locator + "' did not contain value '" + value + "' in attribute '" + attribute + "=" + attributeValue + "'"), (attributeValue.indexOf(value) >= 0 ? 1 : 0) != 0);
    }

    public void attributeContainsValue(PageElement element, String attribute, String value) {
        this.attributeContainsValue(element.getLocator(), attribute, value);
    }

    public void attributeDoesntContainValue(String locator, String attribute, String value) {
        String attributeValue = this.client.getAttribute(locator + "@" + attribute);
        Assert.assertFalse((String)("Element with locator '" + locator + "' did not contain value '" + value + "' in attribute '" + attribute + "'"), (attributeValue.indexOf(value) >= 0 ? 1 : 0) != 0);
    }

    public void attributeDoesntContainValue(PageElement element, String attribute, String value) {
        this.attributeDoesntContainValue(element.getLocator(), attribute, value);
    }

    public void linkPresentWithText(String text) {
        Assert.assertTrue((String)("Expected link with text not found in response: '" + text + "'"), (boolean)this.client.isElementPresent("link=" + text));
    }

    public void linkNotPresentWithText(String text) {
        Assert.assertFalse((String)("Unexpected link with text found in response: '" + text + "'"), (boolean)this.client.isElementPresent("link=" + text));
    }

    public void linkVisibleWithText(String text) {
        this.linkPresentWithText(text);
        Assert.assertTrue((String)("Expected link with text not visible: '" + text + "'"), (boolean)this.client.isVisible("link=" + text));
    }

    public void elementsVerticallyAligned(String locator1, String locator2, int deltaPixels) {
        int middle1 = this.client.getElementPositionTop(locator1).intValue() + this.client.getElementHeight(locator1).intValue() / 2;
        int middle2 = this.client.getElementPositionTop(locator2).intValue() + this.client.getElementHeight(locator2).intValue() / 2;
        String message = "Vertical position of element '" + locator1 + "' (" + middle1 + ") was not within " + deltaPixels + " pixels of the vertical position of element '" + locator2 + "' (" + middle2 + ")";
        Assert.assertTrue((String)message, (Math.abs(middle1 - middle2) <= deltaPixels ? 1 : 0) != 0);
    }

    public void elementsVerticallyAligned(PageElement element1, PageElement element2, int deltaPixels) {
        this.elementsVerticallyAligned(element1.getLocator(), element2.getLocator(), deltaPixels);
    }

    public void elementsSameHeight(String locator1, String locator2, int deltaPixels) {
        int height1 = this.client.getElementHeight(locator1).intValue();
        int height2 = this.client.getElementHeight(locator2).intValue();
        String message = "Height of element '" + locator1 + "' (" + height1 + ") was not within " + deltaPixels + " pixels of the height of element '" + locator2 + "' (" + height2 + ")";
        Assert.assertTrue((String)message, (Math.abs(height1 - height2) <= deltaPixels ? 1 : 0) != 0);
    }

    public void elementsSameHeight(PageElement element1, PageElement element2, int deltaPixels) {
        this.elementsSameHeight(element1.getLocator(), element2.getLocator(), deltaPixels);
    }

    public void elementContainsText(String locator, String text) {
        String elementText = this.client.getText(locator);
        Assert.assertTrue((String)("Element(s) with locator '" + locator + "' did not contain text '" + text + "', but contained '" + elementText + "'"), (elementText.indexOf(text) >= 0 ? 1 : 0) != 0);
    }

    public void elementContainsText(PageElement element, String text) {
        this.elementContainsText(element.getLocator(), text);
    }

    public void elementDoesNotContainText(String locator, String text) {
        Assert.assertFalse((String)("Element(s) with locator '" + locator + "' did contained text '" + text + "'"), (this.client.getText(locator).indexOf(text) >= 0 ? 1 : 0) != 0);
    }

    public void elementDoesNotContainText(PageElement element, String text) {
        this.elementDoesNotContainText(element.getLocator(), text);
    }

    public void windowClosed(String windowName) {
        Assert.assertFalse((boolean)Arrays.asList(this.client.getAllWindowNames()).contains(windowName));
    }

    public void windowOpen(String windowName) {
        Assert.assertTrue((boolean)Arrays.asList(this.client.getAllWindowNames()).contains(windowName));
    }
}

