/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.selenium;

import com.atlassian.selenium.MethodHandlerCallable;
import com.atlassian.selenium.SeleniumClient;
import com.atlassian.selenium.SeleniumConfiguration;
import com.atlassian.selenium.SeleniumReturnValueMismatch;
import com.atlassian.selenium.SingleBrowserSeleniumClient;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiBrowserSeleniumClientInvocationHandler
implements InvocationHandler {
    private List<SeleniumClient> clients = new LinkedList<SeleniumClient>();
    private final long MAX_WAIT;
    private final boolean VERIFY_RETURN_VALUES;
    private final boolean PARALLEL;
    private ExecutorService executorService;

    public MultiBrowserSeleniumClientInvocationHandler(List<SeleniumConfiguration> configs, long maxWait, boolean verifyReturnValues, boolean parallel) {
        for (SeleniumConfiguration config : configs) {
            SingleBrowserSeleniumClient client = new SingleBrowserSeleniumClient(config);
            client.start();
            this.clients.add(client);
        }
        this.VERIFY_RETURN_VALUES = verifyReturnValues;
        this.PARALLEL = parallel;
        if (this.PARALLEL) {
            this.executorService = Executors.newFixedThreadPool(this.clients.size());
            this.MAX_WAIT = maxWait;
        } else {
            this.executorService = Executors.newSingleThreadExecutor();
            this.MAX_WAIT = maxWait * (long)this.clients.size();
        }
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>(this.clients.size());
        for (SeleniumClient client : this.clients) {
            futures.add(this.executorService.submit(new MethodHandlerCallable(method, client, args)));
        }
        this.executorService.awaitTermination(this.MAX_WAIT, TimeUnit.MILLISECONDS);
        if (this.VERIFY_RETURN_VALUES) {
            this.verifyReturnValues(futures);
        }
        return ((Future)futures.get(0)).get();
    }

    public void verifyReturnValues(List<Future<Object>> futures) throws Throwable {
        if (futures.size() > 0) {
            Object first = futures.get(0).get();
            for (int i = 0; i < this.clients.size(); ++i) {
                Object value = futures.get(i).get();
                if (!(first == null ? value != null : !first.equals(value))) continue;
                throw this.createValueMismatchException(this.clients.get(0), first, this.clients.get(i), value);
            }
        }
    }

    protected SeleniumReturnValueMismatch createValueMismatchException(SeleniumClient c1, Object h1, SeleniumClient c2, Object h2) {
        return new SeleniumReturnValueMismatch(c1.getBrowser(), h1, c2.getBrowser(), h2);
    }
}

