/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements.query;

import com.atlassian.pageobjects.elements.query.AbstractPollingQuery;
import com.atlassian.pageobjects.elements.query.ExpirationHandler;
import com.atlassian.pageobjects.elements.query.Poll;
import com.atlassian.pageobjects.elements.query.PollingQuery;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.query.util.ClockAware;
import com.atlassian.pageobjects.elements.query.util.Clocks;
import com.atlassian.pageobjects.elements.util.StringConcat;
import java.time.Clock;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

@NotThreadSafe
public abstract class AbstractTimedQuery<T>
extends AbstractPollingQuery
implements TimedQuery<T>,
ClockAware {
    private final Clock clock;
    private final Poll<T> poll;

    protected AbstractTimedQuery(Clock clock, long defTimeout, long interval, ExpirationHandler expirationHandler) {
        super(interval, defTimeout);
        this.clock = Objects.requireNonNull(clock, "clock");
        this.poll = new Poll(this, this.clock()).every((int)interval, TimeUnit.MILLISECONDS).until(new CustomMatcher()).onFailure(expirationHandler);
    }

    @Override
    public T call() throws Exception {
        return this.currentValue();
    }

    protected ExpirationHandler expirationHandler() {
        return this.poll.expirationHandler;
    }

    protected AbstractTimedQuery(long defTimeout, long interval, ExpirationHandler expirationHandler) {
        this(Clock.systemUTC(), defTimeout, interval, expirationHandler);
    }

    protected AbstractTimedQuery(PollingQuery other, ExpirationHandler expirationHandler) {
        this(Clocks.getClock(other), other.defaultTimeout(), Objects.requireNonNull(other, "other").interval(), expirationHandler);
    }

    @Override
    public final T by(long timeout) {
        try {
            return this.poll.withTimeout((int)timeout, TimeUnit.MILLISECONDS).call();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final T by(long timeout, TimeUnit unit) {
        return this.by(TimeUnit.MILLISECONDS.convert(timeout, unit));
    }

    @Override
    public T byDefaultTimeout() {
        return this.by(this.defaultTimeout);
    }

    @Override
    public final T now() {
        return this.by(1L, TimeUnit.MILLISECONDS);
    }

    protected abstract boolean shouldReturn(T var1);

    protected abstract T currentValue();

    @Override
    public Clock clock() {
        return this.clock;
    }

    public String toString() {
        return StringConcat.asString(this.getClass().getName(), "[interval=", this.interval, ",defaultTimeout=", this.defaultTimeout, "]");
    }

    class CustomMatcher
    extends TypeSafeMatcher<T> {
        CustomMatcher() {
        }

        protected boolean matchesSafely(T item) {
            return AbstractTimedQuery.this.shouldReturn(item);
        }

        public void describeTo(Description description) {
        }
    }
}

