/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.annotations.PublicApi;
import com.atlassian.pageobjects.elements.PageElement;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

@PublicApi
public final class PageElements {
    public static final String BODY = "body";
    public static final String TR = "tr";
    public static final String TD = "td";
    public static final String DATA_PREFIX = "data-";

    private PageElements() {
        throw new AssertionError((Object)("Do not instantiate " + this.getClass().getSimpleName()));
    }

    @Nonnull
    public static Function<PageElement, String> getText() {
        return new Function<PageElement, String>(){

            public String apply(PageElement input) {
                return StringUtils.stripToNull((String)input.getText());
            }
        };
    }

    @Nonnull
    public static Predicate<PageElement> isVisible() {
        return new Predicate<PageElement>(){

            public boolean apply(PageElement input) {
                return input.isVisible();
            }
        };
    }

    @Nonnull
    public static Predicate<PageElement> hasClass(final @Nonnull String className) {
        Preconditions.checkNotNull((Object)className, (Object)"className");
        return new Predicate<PageElement>(){

            public boolean apply(PageElement input) {
                return input.hasClass(className);
            }
        };
    }

    @Nonnull
    public static Predicate<PageElement> hasAttribute(final @Nonnull String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return new Predicate<PageElement>(){

            public boolean apply(PageElement input) {
                return input.getAttribute(attribute) != null;
            }
        };
    }

    @Nonnull
    public static Predicate<PageElement> hasAttribute(final @Nonnull String attribute, final @Nonnull String value) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        Preconditions.checkNotNull((Object)value, (Object)"value");
        return new Predicate<PageElement>(){

            public boolean apply(PageElement input) {
                return input.hasAttribute(attribute, value);
            }
        };
    }

    @Nonnull
    public static Predicate<PageElement> hasDataAttribute(@Nonnull String attribute) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return PageElements.hasAttribute(DATA_PREFIX + attribute);
    }

    @Nonnull
    public static Predicate<PageElement> hasDataAttribute(@Nonnull String attribute, @Nonnull String value) {
        Preconditions.checkNotNull((Object)attribute, (Object)"attribute");
        return PageElements.hasAttribute(DATA_PREFIX + attribute, value);
    }

    @Nonnull
    public static Predicate<PageElement> hasValue(final @Nonnull String value) {
        Preconditions.checkNotNull((Object)value, (Object)"value");
        return new Predicate<PageElement>(){

            public boolean apply(PageElement input) {
                return value.equals(input.getValue());
            }
        };
    }

    @Nonnull
    public static Function<PageElement, Iterable<String>> getCssClasses() {
        return new Function<PageElement, Iterable<String>>(){

            public Set<String> apply(PageElement input) {
                return input.getCssClasses();
            }
        };
    }

    @Nonnull
    public static Function<PageElement, String> getAttribute(final @Nonnull String attributeName) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        return new Function<PageElement, String>(){

            public String apply(PageElement input) {
                return input.getAttribute(attributeName);
            }
        };
    }

    @Nonnull
    public static Function<PageElement, String> getDataAttribute(final @Nonnull String attributeName) {
        Preconditions.checkNotNull((Object)attributeName, (Object)"attributeName");
        return new Function<PageElement, String>(){

            public String apply(PageElement input) {
                return input.getAttribute(PageElements.DATA_PREFIX + attributeName);
            }
        };
    }
}

