/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.elements;

import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.AtlassianWebDriver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.openqa.selenium.NoSuchWindowException;

public class WindowSession {
    private final String defaultWindow;
    private final AtlassianWebDriver driver;
    private final Timeouts timeouts;

    @Inject
    WindowSession(AtlassianWebDriver driver, Timeouts timeouts) {
        this.driver = driver;
        this.timeouts = timeouts;
        this.defaultWindow = driver.getWindowHandle();
    }

    public BrowserWindow openNewWindow(String newWindow) {
        return new BrowserWindow(newWindow).open();
    }

    public BrowserWindow getWindow(String windowName) {
        return new BrowserWindow(windowName);
    }

    private void checkIsOpen(String windowName) {
        Preconditions.checkState((boolean)((Boolean)this.isWindowOpen(windowName).now()), (Object)("Window '" + windowName + "' is not open"));
    }

    public BrowserWindow defaultWindow() {
        return new BrowserWindow(this.defaultWindow);
    }

    public WindowSession switchToDefault() {
        this.driver.switchTo().window(this.defaultWindow);
        return this;
    }

    public TimedCondition isWindowOpen(final String windowName, TimeoutType timeoutType) {
        return new AbstractTimedCondition(this.timeouts.timeoutFor(timeoutType), this.timeouts.timeoutFor(TimeoutType.EVALUATION_INTERVAL)){

            @Override
            protected Boolean currentValue() {
                try {
                    WindowSession.this.driver.switchTo().window(windowName);
                    return true;
                }
                catch (NoSuchWindowException e) {
                    return false;
                }
            }
        };
    }

    public TimedCondition isWindowOpen(String windowName) {
        return this.isWindowOpen(windowName, TimeoutType.PAGE_LOAD);
    }

    public class BrowserWindow {
        private final String windowName;

        private BrowserWindow(String windowName) {
            this.windowName = windowName;
        }

        public TimedCondition isOpen() {
            return WindowSession.this.isWindowOpen(this.windowName);
        }

        private void checkIsOpen() {
            WindowSession.this.checkIsOpen(this.windowName);
        }

        public BrowserWindow open() {
            WindowSession.this.driver.executeScript("window.open('', '" + this.windowName + "')", new Object[0]);
            return this;
        }

        public BrowserWindow switchTo() {
            this.checkIsOpen();
            WindowSession.this.driver.switchTo().window(this.windowName);
            return this;
        }

        public WindowSession switchBack() {
            return WindowSession.this.switchToDefault();
        }

        public WindowSession close() {
            WindowSession.this.driver.switchTo().window(this.windowName);
            WindowSession.this.driver.executeScript("self.close()", new Object[0]);
            return this.switchBack();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WindowSession doInWindow(Runnable runnable) {
            this.switchTo();
            try {
                runnable.run();
                WindowSession windowSession = WindowSession.this;
                return windowSession;
            }
            finally {
                this.switchBack();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <I, O> O doInWindow(@Nullable I input, Function<I, O> function) {
            this.switchTo();
            try {
                Object object = function.apply(input);
                return (O)object;
            }
            finally {
                this.switchBack();
            }
        }
    }
}

