/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;

public class InjectUtils {
    public static <A extends Annotation> void forEachFieldWithAnnotation(Object instance, Class<A> annotation, FieldVisitor<A> fieldVisitor) {
        for (Field field : InjectUtils.findAllFields(instance)) {
            A ann = field.getAnnotation(annotation);
            if (ann == null) continue;
            fieldVisitor.visit(field, ann);
        }
    }

    private static Collection<Field> findAllFields(Object instance) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> cls = instance.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            for (Field field : cls.getDeclaredFields()) {
                if (fields.containsKey(field.getName())) continue;
                fields.put(field.getName(), field);
            }
        }
        return fields.values();
    }

    public static interface FieldVisitor<A extends Annotation> {
        public void visit(Field var1, A var2);
    }
}

