/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.inject;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.pageobjects.inject.InjectionConfiguration;
import com.google.inject.Binder;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@ExperimentalApi
public abstract class AbstractInjectionConfiguration
implements InjectionConfiguration {
    protected final List<InterfaceToImpl<?>> interfacesToImpls = new LinkedList();
    protected final List<InterfaceToInstance<?>> interfacesToInstances = new LinkedList();

    @Override
    @Nonnull
    public final <I> InjectionConfiguration addImplementation(@Nonnull Class<I> interfaceType, @Nonnull Class<? extends I> implementationType) {
        Objects.requireNonNull(interfaceType, "interfaceType");
        Objects.requireNonNull(implementationType, "implementationType");
        this.interfacesToImpls.add(new InterfaceToImpl(interfaceType, implementationType));
        return this;
    }

    @Override
    @Nonnull
    public final <C, I extends C> InjectionConfiguration addSingleton(@Nonnull Class<C> type, @Nonnull I instance) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(instance, "instance");
        this.interfacesToInstances.add(new InterfaceToInstance(type, instance));
        return this;
    }

    protected static class InterfaceToInstance<T> {
        private final Class<T> interfaceType;
        private final T instance;

        private InterfaceToInstance(Class<T> interfaceType, T instance) {
            this.interfaceType = Objects.requireNonNull(interfaceType, "interfaceType");
            this.instance = Objects.requireNonNull(instance, "instance");
            if (!interfaceType.isInstance(instance)) {
                throw new IllegalArgumentException("Object " + instance + " does not implement " + interfaceType.getName());
            }
        }

        public void bind(Binder binder) {
            binder.bind(this.interfaceType).toInstance(this.instance);
        }
    }

    protected static class InterfaceToImpl<T> {
        private final Class<T> interfaceType;
        private final Class<? extends T> implementation;

        private InterfaceToImpl(Class<T> interfaceType, Class<? extends T> implementation) {
            this.interfaceType = Objects.requireNonNull(interfaceType, "interfaceType");
            this.implementation = Objects.requireNonNull(implementation, "implementation");
            if (!interfaceType.isAssignableFrom(implementation)) {
                throw new IllegalArgumentException("Implementation type " + implementation.getName() + " does not implement " + interfaceType.getName());
            }
        }

        public void bind(Binder binder) {
            binder.bind(this.interfaceType).to(this.implementation);
        }
    }
}

