/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pageobjects.inject;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.pageobjects.inject.InjectionConfiguration;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;

@ExperimentalApi
public abstract class AbstractInjectionConfiguration
implements InjectionConfiguration {
    protected final List<InterfaceToImpl> interfacesToImpls = Lists.newLinkedList();
    protected final List<InterfaceToInstance> interfacesToInstances = Lists.newLinkedList();

    @Override
    @Nonnull
    public final <I> InjectionConfiguration addImplementation(@Nonnull Class<I> interfaceType, @Nonnull Class<? extends I> implementationType) {
        Preconditions.checkNotNull(interfaceType, (Object)"interfaceType");
        Preconditions.checkNotNull(implementationType, (Object)"implementationType");
        this.interfacesToImpls.add(new InterfaceToImpl(interfaceType, implementationType));
        return this;
    }

    @Override
    @Nonnull
    public final <C, I extends C> InjectionConfiguration addSingleton(@Nonnull Class<C> type, @Nonnull I instance) {
        Preconditions.checkNotNull(type, (Object)"type");
        Preconditions.checkNotNull(instance, (Object)"instance");
        this.interfacesToInstances.add(new InterfaceToInstance(type, instance));
        return this;
    }

    protected static class InterfaceToInstance {
        public final Class<?> interfaceType;
        public final Object instance;

        private InterfaceToInstance(Class<?> interfaceType, Object instance) {
            this.interfaceType = (Class)Preconditions.checkNotNull(interfaceType, (Object)"interfaceType");
            this.instance = Preconditions.checkNotNull((Object)instance, (Object)"instance");
            if (!interfaceType.isInstance(instance)) {
                throw new IllegalArgumentException("Object " + instance + " does not " + "implement " + interfaceType.getName());
            }
        }
    }

    protected static class InterfaceToImpl {
        public final Class<?> interfaceType;
        public final Class<?> implementation;

        private InterfaceToImpl(Class<?> interfaceType, Class<?> implementation) {
            this.interfaceType = (Class)Preconditions.checkNotNull(interfaceType, (Object)"interfaceType");
            this.implementation = (Class)Preconditions.checkNotNull(implementation, (Object)"implementation");
            if (!interfaceType.isAssignableFrom(implementation)) {
                throw new IllegalArgumentException("Implementation type " + implementation.getName() + " does not " + "implement " + interfaceType.getName());
            }
        }
    }
}

