/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.store.aws;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import software.amazon.awssdk.regions.Region;

public class AwsSecretsManagerParams {
    private final Region region;
    private final String secretId;
    private final String secretPointer;
    private final URI endpointOverride;

    public AwsSecretsManagerParams(@JsonProperty(value="region", required=true) String region, @JsonProperty(value="secretId", required=true) String secretId, @JsonProperty(value="secretPointer") String secretPointer, @JsonProperty(value="endpointOverride") String endpointOverride) {
        if (!Region.regions().contains(Region.of((String)region))) {
            throw new IllegalArgumentException("Invalid region");
        }
        this.region = Region.of((String)region);
        this.endpointOverride = endpointOverride != null ? URI.create(endpointOverride) : null;
        this.secretId = secretId;
        this.secretPointer = secretPointer;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretPointer() {
        return this.secretPointer;
    }

    public String toString() {
        return "SecretsManagerParams{region='" + this.getRegion() + "', secretId='" + this.getSecretId() + "', secretPointer='" + this.getSecretPointer() + "', endpointOverride='" + this.getEndpointOverride() + "'}";
    }

    public Region getRegion() {
        return this.region;
    }

    public URI getEndpointOverride() {
        return this.endpointOverride;
    }
}

