/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.vault;

import com.atlassian.secrets.api.SecretServiceException;
import java.util.Map;
import org.springframework.vault.support.Versioned;

public class VaultUtils {
    private VaultUtils() {
    }

    public static String getSecretValueFromReadResponse(Versioned<Map<String, Object>> readResponse, String key) {
        if (readResponse == null) {
            throw new SecretServiceException("Path to Secret value does not exist.");
        }
        Map data = (Map)readResponse.getData();
        if (data == null) {
            throw new SecretServiceException("Secret value not available. It may be deleted/destroyed.");
        }
        if (data.containsKey(key)) {
            return (String)data.get(key);
        }
        throw new SecretServiceException(String.format("Cannot find secret value for key: %s", key));
    }
}

