/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.secrets.aws;

import com.atlassian.secrets.aws.SecretsManagerClientFactory;
import java.net.URI;
import java.time.Duration;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClient;
import software.amazon.awssdk.services.secretsmanager.SecretsManagerClientBuilder;

public class DefaultSecretsManagerClientFactory
implements SecretsManagerClientFactory {
    public static final long DEFAULT_API_CALL_ATTEMPT_TIMEOUT_SECONDS = 20L;
    public static final long DEFAULT_API_CALL_TIMEOUT_SECONDS = 30L;
    public static final String AWS_API_CALL_ATTEMPT_TIMEOUT_SECONDS_SYSTEM_PROPERTY = "secret.service.aws.apiCallAttemptTimeout";
    public static final String AWS_API_CALL_TIMEOUT_SECONDS_SYSTEM_PROPERTY = "secret.service.aws.apiCallTimeout";

    @Override
    public SecretsManagerClient getClient(Region region) {
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(DefaultSecretsManagerClientFactory.getClientOverrideConfiguration())).region(region)).build();
    }

    @Override
    public SecretsManagerClient getClient(Region region, URI endpointOverride) {
        return (SecretsManagerClient)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)((SecretsManagerClientBuilder)SecretsManagerClient.builder().credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).overrideConfiguration(DefaultSecretsManagerClientFactory.getClientOverrideConfiguration())).region(region)).endpointOverride(endpointOverride)).build();
    }

    private static ClientOverrideConfiguration getClientOverrideConfiguration() {
        long apiCallAttemptTimeout = Long.parseLong(System.getProperty(AWS_API_CALL_ATTEMPT_TIMEOUT_SECONDS_SYSTEM_PROPERTY, String.valueOf(20L)));
        long apiCallTimeout = Long.parseLong(System.getProperty(AWS_API_CALL_TIMEOUT_SECONDS_SYSTEM_PROPERTY, String.valueOf(30L)));
        return (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().apiCallAttemptTimeout(Duration.ofSeconds(apiCallAttemptTimeout)).apiCallTimeout(Duration.ofSeconds(apiCallTimeout)).build();
    }
}

