/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import com.atlassian.search.pagerank.internal.PageDictionary;
import com.atlassian.search.pagerank.internal.PageGraph;
import com.atlassian.search.pagerank.internal.SparsePageGraph;
import com.atlassian.search.pagerank.internal.WeightedLink;
import java.util.List;
import java.util.stream.Collectors;

class SparsePageGraphBuilder<T> {
    private final int[][] tails;
    private final float[][] linkWeights;
    private final float[] sumWeights;
    private final PageDictionary<T> pageDictionary = new PageDictionary();
    private boolean built;

    SparsePageGraphBuilder(int maxPage) {
        this.tails = new int[maxPage][];
        this.linkWeights = new float[maxPage][];
        this.sumWeights = new float[maxPage];
        this.built = false;
    }

    public SparsePageGraphBuilder<T> addLinks(List<T> tails, T head) {
        this.assertNotBuilt();
        this.addWeightedLinks(tails.stream().map(x -> WeightedLink.of(x, 1.0f)).collect(Collectors.toList()), head);
        return this;
    }

    public SparsePageGraphBuilder<T> addWeightedLinks(List<WeightedLink<T>> tails, T head) {
        this.assertNotBuilt();
        int[] pageList = new int[tails.size()];
        float[] weightList = new float[tails.size()];
        for (int i = 0; i < tails.size(); ++i) {
            int tail;
            pageList[i] = tail = this.ord(tails.get(i).getTail());
            weightList[i] = tails.get(i).getWeight();
            int n = tail;
            this.sumWeights[n] = this.sumWeights[n] + weightList[i];
        }
        this.tails[this.ord(head)] = SparsePageGraphBuilder.merge(this.tails[this.ord(head)], pageList);
        this.linkWeights[this.ord(head)] = SparsePageGraphBuilder.merge(this.linkWeights[this.ord(head)], weightList);
        return this;
    }

    public PageGraph build() {
        this.assertNotBuilt();
        this.built = true;
        this.normalizeLinkWeights();
        return new SparsePageGraph(this.pageDictionary.getNumberOfPages(), this.tails, this.linkWeights);
    }

    public PageDictionary<T> getPageDictionary() {
        return this.pageDictionary;
    }

    private int ord(T id) {
        return this.pageDictionary.computeOrd(id);
    }

    private void assertNotBuilt() {
        if (this.built) {
            throw new IllegalStateException("This builder has already built a graph");
        }
    }

    private static int[] merge(int[] a, int[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        int[] result = new int[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private static float[] merge(float[] a, float[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        float[] result = new float[a.length + b.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    private void normalizeLinkWeights() {
        for (int i = 0; i < this.tails.length; ++i) {
            if (this.linkWeights[i] == null) continue;
            int[] pages = this.tails[i];
            for (int j = 0; j < pages.length; ++j) {
                float[] fArray = this.linkWeights[i];
                int n = j;
                fArray[n] = fArray[n] / this.sumWeights[pages[j]];
            }
        }
    }
}

