/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

class PageTree<T> {
    private final Map<T, T> parents = new HashMap<T, T>();

    PageTree() {
    }

    public void put(T parent, T child) {
        this.parents.put(child, parent);
    }

    public int distance(T a, T b) {
        int i;
        int m = this.depth(a);
        int n = this.depth(b);
        T pa = a;
        T pb = b;
        for (i = 0; i < m - n; ++i) {
            pa = this.parent(pa);
        }
        for (i = 0; i < n - m; ++i) {
            pb = this.parent(pb);
        }
        int result = Math.abs(m - n);
        while (!Objects.equals(pa, pb)) {
            pa = this.parent(pa);
            pb = this.parent(pb);
            result += 2;
        }
        return result;
    }

    private T parent(T a) {
        return a == null ? null : (T)this.parents.get(a);
    }

    public int depth(T a) {
        int n = 0;
        T pa = a;
        while (pa != null) {
            ++n;
            pa = this.parent(pa);
        }
        return n - 1;
    }

    public int numberOfPages() {
        return this.parents.size();
    }
}

