/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import com.atlassian.search.pagerank.internal.PageGraph;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PageRankVectorEstimator {
    private static final Logger log = LoggerFactory.getLogger(PageRankVectorEstimator.class);
    private final PageGraph graph;
    private final float dampingFactor;

    PageRankVectorEstimator(PageGraph graph, float dampingFactor) {
        if ((double)dampingFactor < 0.0 || (double)dampingFactor > 1.0) {
            throw new IllegalArgumentException("damping factor must be in the range [0.0, 1.0]");
        }
        this.graph = graph;
        this.dampingFactor = dampingFactor;
    }

    public float[] estimate(int iteration) {
        float[] vector = this.initialVector();
        for (int i = 0; i < iteration; ++i) {
            vector = this.calculate(vector);
        }
        return vector;
    }

    public float[] estimate(float squareError) {
        float[] current;
        float[] previous = this.initialVector();
        while (!(this.squareError(current = this.calculate(previous), previous) < squareError)) {
            previous = current;
        }
        return current;
    }

    private float[] initialVector() {
        float[] vector = new float[this.graph.numberOfPages()];
        Arrays.fill(vector, 1.0f / (float)this.graph.numberOfPages());
        return vector;
    }

    private float squareError(float[] a, float[] b) {
        float result = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            result += (a[i] - b[i]) * (a[i] - b[i]);
        }
        log.debug("squareError: {}", (Object)Float.valueOf(result));
        return result;
    }

    private float[] calculate(float[] vector) {
        float[] result = new float[vector.length];
        for (int head = 0; head < vector.length; ++head) {
            result[head] = this.calculate(head, vector);
        }
        float totalSinkScore = this.totalSinkScore(result);
        log.debug("totalSinkScore: {}", (Object)Float.valueOf(totalSinkScore));
        int head = 0;
        while (head < result.length) {
            int n = head++;
            result[n] = result[n] + totalSinkScore / (float)vector.length;
        }
        return result;
    }

    private float totalSinkScore(float[] vector) {
        float totalSinkScore = 1.0f;
        for (float rank : vector) {
            totalSinkScore -= rank;
        }
        return totalSinkScore;
    }

    private float calculate(int head, float[] vector) {
        float result = 0.0f;
        int[] tails = this.graph.getTails(head);
        float[] weights = this.graph.getLinkWeights(head);
        for (int i = 0; i < tails.length; ++i) {
            result += this.dampingFactor * vector[tails[i]] * weights[i];
        }
        return result += (1.0f - this.dampingFactor) / (float)vector.length;
    }
}

