/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.search.pagerank.api.PageScore;
import com.atlassian.search.pagerank.internal.PageDictionary;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

@ExperimentalApi
public class PageRankVector<T> {
    private final PageDictionary<T> pageDictionary;
    private final float[] values;

    public PageRankVector(PageDictionary<T> pageDictionary, float[] vector) {
        this.pageDictionary = pageDictionary;
        this.values = vector;
    }

    public float get(@Nonnull T pageId) {
        return this.ord(pageId).map(x -> Float.valueOf(this.values[x])).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public int size() {
        return this.values.length;
    }

    public Stream<PageScore<T>> stream() {
        return IntStream.range(0, this.size()).mapToObj(i -> new PageScore<T>(this.id(i), this.values[i]));
    }

    public String toString() {
        return IntStream.range(0, this.pageDictionary.getNumberOfPages()).mapToObj(i -> String.format("%s=%.2f", this.pageDictionary.getId(i), Float.valueOf(this.values[i]))).collect(Collectors.joining(","));
    }

    private Optional<Integer> ord(T id) {
        return this.pageDictionary.getOrd(id);
    }

    private T id(int pageOrd) {
        return this.pageDictionary.getId(pageOrd);
    }
}

