/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;

class PageDictionary<T> {
    private final BiMap<T, Integer> pageOrdinalById = HashBiMap.create();
    private int maxOrdinal = 0;

    PageDictionary() {
    }

    public Optional<Integer> getOrd(T pageId) {
        return Optional.ofNullable(this.pageOrdinalById.get(pageId));
    }

    public int computeOrd(T pageId) {
        return (Integer)this.pageOrdinalById.computeIfAbsent(pageId, id -> this.maxOrdinal++);
    }

    public T getId(int pageOrd) {
        return (T)this.pageOrdinalById.inverse().get((Object)pageOrd);
    }

    public void add(T pageId) {
        if (pageId != null) {
            this.computeOrd(pageId);
        }
    }

    public int getNumberOfPages() {
        return this.maxOrdinal;
    }
}

