/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import com.atlassian.search.pagerank.api.PageRankCalculator;
import com.atlassian.search.pagerank.api.PageScore;
import com.atlassian.search.pagerank.internal.BulkPageLink;
import com.atlassian.search.pagerank.internal.BulkPageLinkStream;
import com.atlassian.search.pagerank.internal.PageLink;
import com.atlassian.search.pagerank.internal.PageRankVector;
import com.atlassian.search.pagerank.internal.PageRankVectorEstimator;
import com.atlassian.search.pagerank.internal.PageTree;
import com.atlassian.search.pagerank.internal.SparsePageGraphBuilder;
import com.atlassian.search.pagerank.spi.CrossLink;
import com.atlassian.search.pagerank.spi.CrossLinkProvider;
import com.atlassian.search.pagerank.spi.ParentLink;
import com.atlassian.search.pagerank.spi.ParentLinkProvider;
import java.util.Objects;
import java.util.stream.Stream;

public class DefaultPageRankCalculator<T>
implements PageRankCalculator<T> {
    private static final int DEFAULT_SPACE_DISTANCE = 10;
    private static final int DEFAULT_NUMBER_OF_ITERATIONS = 50;
    private static final float DAMPING_FACTOR = 0.85f;
    private final CrossLinkProvider<T> crossLinkProvider;
    private final ParentLinkProvider<T> parentLinkProvider;

    public DefaultPageRankCalculator(CrossLinkProvider<T> crossLinkProvider, ParentLinkProvider<T> parentLinkProvider) {
        this.crossLinkProvider = Objects.requireNonNull(crossLinkProvider);
        this.parentLinkProvider = Objects.requireNonNull(parentLinkProvider);
    }

    public Stream<PageScore<T>> calculate(float dampingFactor, float squareError) {
        SparsePageGraphBuilder<T> builder = this.createGraphBuilder();
        PageRankVectorEstimator estimator = new PageRankVectorEstimator(builder.build(), dampingFactor);
        return new PageRankVector<T>(builder.getPageDictionary(), estimator.estimate(squareError)).stream();
    }

    public Stream<PageScore<T>> calculate(float dampingFactor, int iteration) {
        SparsePageGraphBuilder<T> builder = this.createGraphBuilder();
        PageRankVectorEstimator estimator = new PageRankVectorEstimator(builder.build(), dampingFactor);
        return new PageRankVector<T>(builder.getPageDictionary(), estimator.estimate(iteration)).stream();
    }

    @Override
    public Stream<PageScore<T>> calculate() {
        return this.calculate(0.85f, 50);
    }

    private SparsePageGraphBuilder<T> createGraphBuilder() {
        PageTree<T> pageTree = this.createPageTree();
        SparsePageGraphBuilder builder = new SparsePageGraphBuilder(pageTree.numberOfPages());
        try (Stream<BulkPageLink<BulkPageLink>> stream = BulkPageLinkStream.of(this.getPageLinks(pageTree));){
            stream.forEach(x -> builder.addWeightedLinks(x.getTails(), x.getHead()));
        }
        return builder;
    }

    private Stream<PageLink<T>> getPageLinks(PageTree<T> tree) {
        return this.crossLinkProvider.get().map(x -> new PageLink(x.fromPage(), x.toPage(), this.getDistance(tree, (CrossLink<T>)x)));
    }

    private int getDistance(PageTree<T> tree, CrossLink<T> crossLink) {
        int distance = !Objects.equals(crossLink.toSpace(), crossLink.fromSpace()) ? tree.depth(crossLink.fromPage()) + tree.depth(crossLink.toPage()) + 10 : tree.distance(crossLink.fromPage(), crossLink.toPage());
        return distance;
    }

    private PageTree<T> createPageTree() {
        PageTree tree = new PageTree();
        try (Stream<ParentLink<ParentLink>> stream = this.parentLinkProvider.get();){
            stream.forEach(x -> tree.put(x.parent(), x.child()));
        }
        return tree;
    }
}

