/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.search.pagerank.internal;

import com.atlassian.search.pagerank.internal.BulkPageLink;
import com.atlassian.search.pagerank.internal.PageLink;
import com.atlassian.search.pagerank.internal.WeightedLink;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

final class BulkPageLinkStream {
    BulkPageLinkStream() {
    }

    static <T> Stream<BulkPageLink<T>> of(Stream<PageLink<T>> stream) {
        Stream result = StreamSupport.stream(new BulkPageLinkSpliterator(stream.iterator()), false);
        return (Stream)result.onClose(stream::close);
    }

    private static class BulkPageLinkSpliterator<T>
    implements Spliterator<BulkPageLink<T>> {
        private final Iterator<PageLink<T>> source;
        private T currentHead = null;
        private List<WeightedLink<T>> currentTails = new ArrayList<WeightedLink<T>>();

        private BulkPageLinkSpliterator(Iterator<PageLink<T>> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public boolean tryAdvance(Consumer<? super BulkPageLink<T>> action) {
            while (this.source.hasNext()) {
                PageLink<T> link = this.source.next();
                if (this.currentHead == null) {
                    this.currentHead = link.getHead();
                }
                if (this.currentHead == link.getHead()) {
                    this.currentTails.add(WeightedLink.of(link.getTail(), link.getDistance()));
                    continue;
                }
                action.accept(new BulkPageLink<T>(this.currentTails, this.currentHead));
                this.currentHead = link.getHead();
                this.currentTails.clear();
                this.currentTails.add(WeightedLink.of(link.getTail(), link.getDistance()));
                return true;
            }
            if (this.currentTails.size() > 0) {
                action.accept(new BulkPageLink<T>(this.currentTails, this.currentHead));
            }
            return false;
        }

        @Override
        public Spliterator<BulkPageLink<T>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1040;
        }
    }
}

