/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.compat.local;

import com.atlassian.sal.api.scheduling.PluginJob;
import com.atlassian.scheduler.compat.JobHandler;
import com.atlassian.scheduler.compat.JobInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class LocalOnlyPluginJob
implements PluginJob {
    static final String JOB_INFO = "JobInfo";
    static final String JOB_HANDLER = "JobHandler";

    public void execute(Map<String, Object> jobDataMap) {
        Objects.requireNonNull(jobDataMap, "jobDataMap");
        JobInfo jobInfo = (JobInfo)Objects.requireNonNull(jobDataMap.get(JOB_INFO), JOB_INFO);
        JobHandler jobHandler = (JobHandler)Objects.requireNonNull(jobDataMap.get(JOB_HANDLER), JOB_HANDLER);
        jobHandler.execute(jobInfo);
    }

    static Map<String, Object> toJobDataMap(JobInfo jobInfo, JobHandler jobHandler) {
        HashMap<String, Object> jobDataMap = new HashMap<String, Object>(4);
        jobDataMap.put(JOB_INFO, Objects.requireNonNull(jobInfo, JOB_INFO));
        jobDataMap.put(JOB_HANDLER, Objects.requireNonNull(jobHandler, JOB_HANDLER));
        return Collections.unmodifiableMap(jobDataMap);
    }
}

