/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.spring.component;

import com.atlassian.sal.api.component.ComponentLocator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.AbstractApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringComponentLocator
extends ComponentLocator
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private static final Logger log = Logger.getLogger(SpringComponentLocator.class);

    public SpringComponentLocator() {
        ComponentLocator.setComponentLocator((ComponentLocator)this);
    }

    protected <T> T getComponentInternal(Class<T> iface) {
        Map<String, T> beansOfType = this.getBeansOfType(iface);
        if (beansOfType.isEmpty()) {
            throw new RuntimeException("Could not retrieve " + iface.getName());
        }
        if (beansOfType.size() > 1) {
            String shortClassName = this.convertClassToName(iface);
            T implementation = beansOfType.get(shortClassName);
            if (implementation == null) {
                log.warn((Object)("More than one instance of " + iface.getName() + " found but none of them has key " + shortClassName));
            }
            return implementation;
        }
        return beansOfType.values().iterator().next();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected <T> Collection<T> getComponentsInternal(Class<T> iface) {
        Map<String, T> beansOfType = this.getBeansOfType(iface);
        return beansOfType.values();
    }

    private <T> Map<String, T> getBeansOfType(Class<T> iface) {
        try {
            return this.applicationContext.getBeansOfType(iface);
        }
        catch (BeansException e) {
            AbstractApplicationContext abstractApplicationContext;
            ConfigurableListableBeanFactory beanFactory;
            log.debug((Object)e, (Throwable)e);
            HashMap<String, Object> results = new HashMap<String, Object>();
            if (this.applicationContext instanceof AbstractApplicationContext && (beanFactory = (abstractApplicationContext = (AbstractApplicationContext)this.applicationContext).getBeanFactory()) instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory defaultListableBeanFactory = (DefaultListableBeanFactory)beanFactory;
                String[] beanDefinitionNames = defaultListableBeanFactory.getBeanDefinitionNames();
                for (int i = 0; i < beanDefinitionNames.length; ++i) {
                    String beanName = beanDefinitionNames[i];
                    try {
                        Object bean = defaultListableBeanFactory.getBean(beanName);
                        if (bean == null || !iface.isAssignableFrom(bean.getClass())) continue;
                        results.put(beanName, bean);
                        continue;
                    }
                    catch (BeansException e2) {
                        // empty catch block
                    }
                }
            }
            return results;
        }
    }
}

