/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.pluginsettings;

import com.atlassian.sal.core.pluginsettings.AbstractStringPluginSettings;
import com.atlassian.sal.core.pluginsettings.EscapeUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PluginSettingStringSerializer {
    private static final String STR_IDENTIFIER = "#java.lang.String";
    private static final String BOOL_IDENTIFIER = "#java.lang.Boolean";
    private static final String LONG_IDENTIFIER = "#java.lang.Long";
    private static final String INT_IDENTIFIER = "#java.lang.Integer";
    private static final String LIST_IDENTIFIER = "#java.util.List";
    private static final String SET_IDENTIFIER = "#java.util.Set";
    private static final String MAP_IDENTIFIER = "#java.util.Map";
    private static final String PROPERTIES_IDENTIFIER = "#java.util.Properties";
    private static final String PROPERTIES_ENCODING = "ISO8859_1";

    static Object deserialize(String val) {
        return PluginSettingStringSerializer.deserialize(val, StringSerializationMode.SAFE);
    }

    public static Object deserialize(String val, StringSerializationMode stringSerializationMode) {
        if (val == null) {
            return null;
        }
        if (stringSerializationMode == StringSerializationMode.SAFE && val.startsWith(STR_IDENTIFIER)) {
            return val.substring(STR_IDENTIFIER.length() + 1);
        }
        if (val.startsWith(BOOL_IDENTIFIER)) {
            return Boolean.parseBoolean(val.substring(BOOL_IDENTIFIER.length() + 1));
        }
        if (val.startsWith(PROPERTIES_IDENTIFIER)) {
            return PluginSettingStringSerializer.deserializeProperties(val);
        }
        if (val.startsWith(LIST_IDENTIFIER) || val.startsWith(SET_IDENTIFIER)) {
            return PluginSettingStringSerializer.deserializeCollection(val);
        }
        if (val.startsWith(MAP_IDENTIFIER)) {
            return PluginSettingStringSerializer.deserializeMap(val);
        }
        try {
            if (val.startsWith(INT_IDENTIFIER)) {
                return Integer.parseInt(val.substring(INT_IDENTIFIER.length() + 1));
            }
            if (val.startsWith(LONG_IDENTIFIER)) {
                return Long.parseLong(val.substring(LONG_IDENTIFIER.length() + 1));
            }
        }
        catch (NumberFormatException e) {
            throw new AbstractStringPluginSettings.CorruptPluginSettingValueException("Unparsable number type value", e);
        }
        if (stringSerializationMode == StringSerializationMode.SAFE) {
            throw new AbstractStringPluginSettings.CorruptPluginSettingValueException("Unrecognized value type: " + val);
        }
        return val;
    }

    static Properties deserializeProperties(String val) {
        Properties props = new Properties();
        try {
            props.load(new ByteArrayInputStream(val.getBytes(PROPERTIES_ENCODING)));
        }
        catch (IOException e) {
            throw new AbstractStringPluginSettings.CorruptPluginSettingValueException("Unable to deserialize properties", e);
        }
        return props;
    }

    static Collection<String> deserializeCollection(String val) {
        String[] lines = val.split(String.valueOf('\n'));
        List<String> rawItems = Arrays.asList(lines).subList(1, lines.length);
        Stream<String> stream = rawItems.stream().map(EscapeUtils::unescape);
        if (val.startsWith(LIST_IDENTIFIER)) {
            return stream.collect(Collectors.toList());
        }
        if (val.startsWith(SET_IDENTIFIER)) {
            return stream.collect(Collectors.toSet());
        }
        throw new AbstractStringPluginSettings.CorruptPluginSettingValueException("Unparsable collection");
    }

    static Map<String, String> deserializeMap(String val) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] lines = val.split(String.valueOf('\n'));
        List<String> rawItems = Arrays.asList(lines).subList(1, lines.length);
        for (String item : rawItems) {
            int tabIndex = item.indexOf(12);
            if (tabIndex == -1) {
                throw new AbstractStringPluginSettings.CorruptPluginSettingValueException("Unparsable map item");
            }
            String keyPart = item.substring(0, tabIndex);
            String valuePart = item.substring(tabIndex + 1);
            map.put(EscapeUtils.unescape(keyPart), EscapeUtils.unescape(valuePart));
        }
        return map;
    }

    static String serialize(Object val) {
        return PluginSettingStringSerializer.serialize(val, StringSerializationMode.SAFE);
    }

    public static String serialize(Object value, StringSerializationMode stringSerializationMode) {
        if (value instanceof String) {
            String str = (String)value;
            return stringSerializationMode == StringSerializationMode.LEGACY ? str : PluginSettingStringSerializer.prefixIdentifier(str, STR_IDENTIFIER);
        }
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            return PluginSettingStringSerializer.prefixIdentifier(bool, BOOL_IDENTIFIER);
        }
        if (value instanceof Long) {
            Long longValue = (Long)value;
            return PluginSettingStringSerializer.prefixIdentifier(longValue, LONG_IDENTIFIER);
        }
        if (value instanceof Integer) {
            Integer integer = (Integer)value;
            return PluginSettingStringSerializer.prefixIdentifier(integer, INT_IDENTIFIER);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return PluginSettingStringSerializer.serializeCollection(collection);
        }
        if (value instanceof Properties) {
            Properties properties = (Properties)value;
            return PluginSettingStringSerializer.serializeProperties(properties);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return PluginSettingStringSerializer.serializeMap(map);
        }
        throw new AbstractStringPluginSettings.UnsupportedPluginSettingValueTypeException("Property type: " + String.valueOf(value.getClass()) + " not supported");
    }

    static String serializeCollection(Collection<?> collection) {
        if (collection instanceof List) {
            List list = (List)collection;
            return PluginSettingStringSerializer.serializeList(list);
        }
        if (collection instanceof Set) {
            Set set = (Set)collection;
            return PluginSettingStringSerializer.serializeSet(set);
        }
        throw new AbstractStringPluginSettings.UnsupportedPluginSettingValueTypeException("Property type: " + String.valueOf(collection.getClass()) + " not supported");
    }

    static String serializeList(List<?> list) {
        String unprefixed = PluginSettingStringSerializer.serializeCollectionHelper(list);
        return PluginSettingStringSerializer.prefixIdentifier(unprefixed, LIST_IDENTIFIER);
    }

    static String serializeSet(Set<?> set) {
        String unprefixed = PluginSettingStringSerializer.serializeCollectionHelper(set);
        return PluginSettingStringSerializer.prefixIdentifier(unprefixed, SET_IDENTIFIER);
    }

    private static String serializeCollectionHelper(Collection<?> collection) {
        StringBuilder sb = new StringBuilder();
        for (Object i : collection) {
            sb.append(EscapeUtils.escape(i.toString()));
            sb.append('\n');
        }
        if (!collection.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    static String serializeProperties(Properties properties) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            properties.store(bout, PROPERTIES_IDENTIFIER.substring(1));
            return bout.toString(PROPERTIES_ENCODING);
        }
        catch (IOException e) {
            throw new AbstractStringPluginSettings.UnsupportedPluginSettingValueTypeException("Unable to serialize properties", e);
        }
    }

    static String serializeMap(Map<?, ?> map) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            sb.append(EscapeUtils.escape(entry.getKey().toString()));
            sb.append('\f');
            sb.append(EscapeUtils.escape(entry.getValue().toString()));
            sb.append('\n');
        }
        if (!map.isEmpty()) {
            sb.setLength(sb.length() - 1);
        }
        return PluginSettingStringSerializer.prefixIdentifier(sb.toString(), MAP_IDENTIFIER);
    }

    private static String prefixIdentifier(Object value, String typeIdentifier) {
        return typeIdentifier + "\n" + String.valueOf(value);
    }

    public static enum StringSerializationMode {
        LEGACY,
        SAFE;

    }
}

