/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.core.pluginsettings;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

class EscapeUtils {
    protected static final char VERTICAL_TAB = '\f';
    protected static final char NEW_LINE = '\n';
    protected static final char BACKSLASH = '\\';

    private EscapeUtils() {
    }

    protected static String escape(String str) {
        if (str == null) {
            return null;
        }
        StringWriter writer = new StringWriter(str.length() * 2);
        try {
            EscapeUtils.escape(writer, str);
        }
        catch (IOException e) {
            throw new IllegalStateException("exception while writing to StringWriter (should be impossible in this context)", e);
        }
        return writer.toString();
    }

    private static void escape(Writer out, String str) throws IOException {
        int len = str.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\f': {
                    out.write(92);
                    out.write(102);
                    continue block5;
                }
                case '\n': {
                    out.write(92);
                    out.write(110);
                    continue block5;
                }
                case '\\': {
                    out.write(92);
                    out.write(92);
                    continue block5;
                }
                default: {
                    out.write(ch);
                }
            }
        }
    }

    public static String unescape(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            EscapeUtils.unescape(writer, str);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("exception while writing to StringWriter (should be impossible in this context)", e);
        }
    }

    private static void unescape(Writer out, String str) throws IOException {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                if (i + 1 >= len) {
                    throw new IllegalArgumentException("Invalid escape sequence: trailing backslash at position " + i);
                }
                char nextCh = str.charAt(i + 1);
                switch (nextCh) {
                    case 'f': {
                        out.write(12);
                        ++i;
                        break;
                    }
                    case 'n': {
                        out.write(10);
                        ++i;
                        break;
                    }
                    case '\\': {
                        out.write(92);
                        ++i;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid escape sequence: \\" + nextCh + " at position " + i);
                    }
                }
                continue;
            }
            out.write(ch);
        }
    }
}

